Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Seq.
Require Import Metarouting.Constructions.Semigroups.Prefix.

Definition prefixSemigroup_props {a} (ap : dsProp a) : sgProp (prefixSemigroup a).
   intros a ap.
   apply (Build_sgProp (prefixSemigroup a) (seqDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply None.
   apply (opInit (Prefix.hasIdentity_comp a)).

   (* HasAnnihilator *)
   apply (opInit (Prefix.hasAnnihilator a)).
   apply None.

   (* IsSelective *)
   apply (opMap (@Prefix.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Prefix.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opInit (@Prefix.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply (opInit (Prefix.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (Prefix.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (Prefix.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (Prefix.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (Prefix.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (Prefix.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (Prefix.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@Prefix.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@Prefix.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@Prefix.treeGlb a)).
   apply None.
Defined.
