Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Nat.

Definition natPlusSemigroup_props : sgProp natPlusSemigroup.
   apply Build_sgProp.
   apply natDecSetoid_props.
   
   (* HasIdentity *)
   apply (opInit NatPlus.hasIdentity).
   apply None.

   (* HasAnnihilator *)
   apply None.
   apply (opInit NatPlus.hasAnnihilator_comp).

   (* IsSelective *)
   apply None.
   apply (opInit NatPlus.isSelective_comp).

   (* IsCommutative *)
   apply (opInit NatPlus.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply None.
   apply (opInit NatPlus.isIdempotent_comp).

   (* IsLeft *)
   apply None.
   apply (opInit NatPlus.isLeft_comp).

   (* IsRight *)
   apply None.
   apply (opInit NatPlus.isRight_comp).

   (* LeftCondensed *)
   apply None.
   apply (opInit NatPlus.leftCondensed_comp).

   (* RightCondensed *)
   apply None.
   apply (opInit NatPlus.rightCondensed_comp).

   (* LeftCancelative *)
   apply (opInit NatPlus.leftCancelative).
   apply None.

   (* RightCancelative *)
   apply (opInit NatPlus.rightCancelative).
   apply None.

   (* AntiLeft *)
   apply None.
   apply (opInit NatPlus.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit NatPlus.antiRight_comp).

   (* TreeGlb *)
   apply None.
   apply (opInit NatPlus.treeGlb_comp).
Defined.
