Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Nat.

Definition natMinSemigroup_props : sgProp natMinSemigroup.
   apply Build_sgProp.
   apply natDecSetoid_props.
   
   (* HasIdentity *)
   apply None.
   apply (opInit NatMin.hasIdentity_comp).

   (* HasAnnihilator *)
   apply (opInit NatMin.hasAnnihilator).
   apply None.

   (* IsSelective *)
   apply (opInit NatMin.isSelective).
   apply None.

   (* IsCommutative *)
   apply (opInit NatMin.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply (opInit NatMin.isIdempotent).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit NatMin.isLeft_comp).

   (* IsRight *)
   apply None.
   apply (opInit NatMin.isRight_comp).

   (* LeftCondensed *)
   apply None.
   apply (opInit NatMin.leftCondensed_comp).

   (* RightCondensed *)
   apply None.
   apply (opInit NatMin.rightCondensed_comp).

   (* LeftCancelative *)
   apply None.
   apply (opInit NatMin.leftCancelative_comp).

   (* RightCancelative *)
   apply None.
   apply (opInit NatMin.rightCancelative_comp).

   (* AntiLeft *)
   apply None.
   apply (opInit NatMin.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit NatMin.antiRight_comp).

   (* TreeGlb *)
   apply (opInit NatMin.treeGlb).
   apply None.
Defined.
