Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Left.
Require Import Metarouting.Inference.Common.Common.

Definition leftSemigroup_props {a} (ap : dsProp a) : sgProp (leftSemigroup a).
   intros a ap;
   apply (Build_sgProp (leftSemigroup a) ap);
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@Left.hasIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.hasIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@Left.hasAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.hasAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opInit (@Left.isSelective a)).
   apply None.

   (* IsCommutative *)
   apply (opMap (@Left.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opInit (@Left.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply (opInit (@Left.isLeft a)).
   apply None.

   (* IsRight *)
   apply (opMap (@Left.isRight a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isRight_comp a)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opInit (@Left.leftCondensed a)).
   apply None.

   (* RightCondensed *)
   apply (opMap (@Left.rightCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.rightCondensed_comp a)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@Left.leftCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.leftCancelative_comp a)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opInit (@Left.rightCancelative a)).
   apply None.

   (* AntiLeft *)
   apply None.
   apply (opInit (@Left.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@Left.antiRight_comp a)).

   (* TreeGlb *)
   apply (opInit (@Left.treeGlb a)).
   apply None.
Defined.
