Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.FSetsIntersect.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.FSets.

Definition fsetsIntersectionSemigroup_props {a} (ap : dsProp a) : sgProp (fsetsIntersectionSemigroup a).
   intros;
   apply (Build_sgProp (fsetsIntersectionSemigroup a) (fsetDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@FSetsIntersect.hasIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsIntersect.hasIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opInit (@FSetsIntersect.hasAnnihilator a)).
   apply None.

   (* IsSelective *)
   apply (opMap (@FSetsIntersect.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsIntersect.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opInit (@FSetsIntersect.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply (opInit (@FSetsIntersect.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (@FSetsIntersect.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@FSetsIntersect.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@FSetsIntersect.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@FSetsIntersect.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@FSetsIntersect.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@FSetsIntersect.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@FSetsIntersect.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@FSetsIntersect.antiRight_comp a)).

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
