Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.FSets.

Definition fsetOpSemigroup_props {a} (ap : sgProp a) : sgProp (fsetOpSemigroup a).
   intros;
   apply (Build_sgProp (fsetOpSemigroup a) (fsetDecSetoid_props ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@FSetOp.hasIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetOp.hasIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opInit (@FSetOp.hasAnnihilator a)).
   apply None.

   (* IsSelective *)
   apply (opMap (@FSetOp.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetOp.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@FSetOp.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetOp.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@FSetOp.isIdempotent a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetOp.isIdempotent_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply None.
   apply (opInit (@FSetOp.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@FSetOp.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@FSetOp.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@FSetOp.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@FSetOp.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@FSetOp.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@FSetOp.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@FSetOp.antiRight_comp a)).

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
