Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.FMinSetsOp.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.FMinSets.

Definition msetOpSemigroup_props {a} lmon rmon antisym (ap : osProp a) : sgProp (msetOpSemigroup a lmon rmon antisym).
   intros;
   apply (Build_sgProp (msetOpSemigroup a lmon rmon antisym) (msetDecSetoid_props antisym ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@FMinSetsOp.hasIdentity a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply None. (* Not an iff rule *)

   (* HasAnnihilator *)
   apply (opInit (@FMinSetsOp.hasAnnihilator a lmon rmon antisym)).
   apply None.

   (* IsSelective *)
   apply (opMap (@FMinSetsOp.isSelective a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOp.isSelective_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@FMinSetsOp.isCommutative a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOp.isCommutative_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@FMinSetsOp.isIdempotent a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOp.isIdempotent_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply None.
   apply (opInit (@FMinSetsOp.isLeft_comp a lmon rmon antisym)).

   (* IsRight *)
   apply None.
   apply (opInit (@FMinSetsOp.isRight_comp a lmon rmon antisym)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@FMinSetsOp.leftCondensed_comp a lmon rmon antisym)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@FMinSetsOp.rightCondensed_comp a lmon rmon antisym)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@FMinSetsOp.leftCancelative_comp a lmon rmon antisym)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@FMinSetsOp.rightCancelative_comp a lmon rmon antisym)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@FMinSetsOp.antiLeft_comp a lmon rmon antisym)).

   (* AntiRight *)
   apply None.
   apply (opInit (@FMinSetsOp.antiRight_comp a lmon rmon antisym)).

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
