Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.FMinSets.

Definition msetUnionSemigroup_props {a} (antisym : Antisym a) (ap : poProp a) : sgProp (msetUnionSemigroup a).
   intros;
   apply (Build_sgProp (msetUnionSemigroup a) (msetDecSetoid_props antisym ap));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opInit (@FMinSetsUnion.hasIdentity a)).
   apply None.

   (* HasAnnihilator *)
   apply (opMap (@FMinSetsUnion.hasAnnihilator a)); opUnfoldBoolFormula; fail.
   apply None. (* no iff-rule *)

   (* IsSelective *)
   apply (opMap (@FMinSetsUnion.isSelective a antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsUnion.isSelective_comp a antisym)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opInit (@FMinSetsUnion.isCommutative a)).
   apply None.

   (* IsIdempotent *)
   apply (opInit (@FMinSetsUnion.isIdempotent a)).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (@FMinSetsUnion.isLeft_comp a)).

   (* IsRight *)
   apply None.
   apply (opInit (@FMinSetsUnion.isRight_comp a)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@FMinSetsUnion.leftCondensed_comp a)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@FMinSetsUnion.rightCondensed_comp a)).

   (* LeftCancelative *)
   apply None.
   apply (opInit (@FMinSetsUnion.leftCancelative_comp a)).

   (* RightCancelative *)
   apply None.
   apply (opInit (@FMinSetsUnion.rightCancelative_comp a)).

   (* AntiLeft *)
   apply None.
   apply (opInit (@FMinSetsUnion.antiLeft_comp a)).

   (* AntiRight *)
   apply None.
   apply (opInit (@FMinSetsUnion.antiRight_comp a)).

   (* TreeGlb *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
Defined.
