Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.BoolAnd.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Bool.

Definition boolAndSemigroup_props : sgProp boolAndSemigroup.
   apply Build_sgProp.
   apply boolDecSetoid_props.
   
   (* HasIdentity *)
   apply (opInit BoolAnd.hasIdentity).
   apply None.

   (* HasAnnihilator *)
   apply (opInit BoolAnd.hasAnnihilator).
   apply None.

   (* IsSelective *)
   apply (opInit BoolAnd.isSelective).
   apply None.

   (* IsCommutative *)
   apply (opInit BoolAnd.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply (opInit BoolAnd.isIdempotent).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit BoolAnd.isLeft_comp).

   (* IsRight *)
   apply None.
   apply (opInit BoolAnd.isRight_comp).

   (* LeftCondensed *)
   apply None.
   apply (opInit BoolAnd.leftCondensed_comp).

   (* RightCondensed *)
   apply None.
   apply (opInit BoolAnd.rightCondensed_comp).

   (* LeftCancelative *)
   apply None.
   apply (opInit BoolAnd.leftCancelative_comp).

   (* RightCancelative *)
   apply None.
   apply (opInit BoolAnd.rightCancelative_comp).

   (* AntiLeft *)
   apply None.
   apply (opInit BoolAnd.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit BoolAnd.antiRight_comp).

   (* TreeGlb *)
   apply (opInit BoolAnd.treeGlb).
   apply None.
Defined.
