Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.Semigroups.Lex.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Metarouting.Constructions.SemigroupTransforms.Lex.
Require Import Metarouting.Inference.Transforms.Product.
Require Import Metarouting.Inference.Semigroups.Lex.
Require Import Metarouting.Inference.Common.Common.

Definition lexSemigroupTransform_props {a b} (ap : stProp a) (bp : stProp b) comm idem hasId (strict : Strict b) : stProp (lexSemigroupTransform a b comm idem hasId).
   intros.
   
   assert (sgProp (lexSemigroupTransform a b comm idem hasId)) as sgp.
      unfold lexSemigroupTransform.
      apply (sgPropIso (glueSTfSmg_DsEq (lexSemigroup a b comm idem hasId) (prodTransform a b) _)).
      apply lexSemigroup_props. apply ap. apply bp.

   assert (tfProp (lexSemigroupTransform a b comm idem hasId)) as tfp.
      apply (tfPropIso (glueSTfTf_DsEq (lexSemigroup a b comm idem hasId) (prodTransform a b) _)).
      apply prodTransform_props. apply ap. apply bp.

   apply (Build_stProp (lexSemigroupTransform a b comm idem hasId) sgp tfp);
   hypPropSplit.

   (* Distributive *)
   apply (opMap (Lex.distributive a b comm idem hasId strict)); opUnfoldBoolFormula; fail.
   apply (opMap (Lex.distributive_comp a b comm idem hasId strict)); opUnfoldBoolFormula; fail.

   (* Inflationary *)
   apply (opMap (Lex.inflationary a b comm idem hasId)); opUnfoldBoolFormula; fail.
   apply (opMap (Lex.inflationary_comp a b comm idem hasId)); opUnfoldBoolFormula; fail.

   (* StrictInflationary *)
   apply (opMap (Lex.strictInflationary a b comm idem hasId)); opUnfoldBoolFormula; fail.
   apply (opMap (Lex.strictInflationary_comp a b comm idem hasId)); opUnfoldBoolFormula; fail.

   (* Strict *)
   apply (opMap (Lex.strict a b comm idem hasId)); opUnfoldBoolFormula; fail.
   apply (opMap (Lex.strict_comp a b comm idem hasId)); opUnfoldBoolFormula; fail.

Defined.

