Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.Transforms.Cayley.
Require Import Metarouting.Constructions.SemigroupTransforms.Cayley.
Require Import Metarouting.Inference.Transforms.Cayley.
Require Import Metarouting.Inference.Common.Common.

Definition cayleyMapSemigroupTransform_props {a} (ap : bsProp a) : stProp (cayleyMapSemigroupTransform a).
   intros a ap.
   
   assert (sgProp (cayleyMapSemigroupTransform a)) as sgp.
      apply (sgPropIso (glueSTfSmg_DsEq (plusSmg a) (cayleyMapTransform (timesSmg a)) _)).
      apply ap.

   assert (tfProp (cayleyMapSemigroupTransform a)) as tfp.
      apply (tfPropIso (glueSTfTf_DsEq (plusSmg a) (cayleyMapTransform (timesSmg a)) _)).
      apply cayleyMapTransform_props.
      apply ap.

   apply (Build_stProp (cayleyMapSemigroupTransform a) sgp tfp);
   hypPropSplit.

   (* Distributive *)
   apply (opMap (Cayley.distributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (Cayley.distributive_comp a)); opUnfoldBoolFormula; fail.

   (* Inflationary *)
   apply (opMap (Cayley.inflationary a)); opUnfoldBoolFormula; fail.
   apply (opMap (Cayley.inflationary_comp a)); opUnfoldBoolFormula; fail.

   (* StrictInflationary *)
   apply (opMap (Cayley.strictInflationary a)); opUnfoldBoolFormula; fail.
   apply (opMap (Cayley.strictInflationary_comp a)); opUnfoldBoolFormula; fail.

   (* Strict *)
   apply (opMap (Cayley.strict a)); opUnfoldBoolFormula; fail.
   apply (opMap (Cayley.strict_comp a)); opUnfoldBoolFormula; fail.

Defined.
