Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Preorders.Lex.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.

Definition lexPreorder_props {a} {b} (ap : poProp a) (bp : poProp b): poProp (lexPreorder a b).
   intros.
   apply (Build_poProp (lexPreorder a b) (prodDecSetoid_props ap bp));
   hypPropSplit.
   
   (* HasTop *)
   apply (opMap (@Lex.hasTop a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.hasTop_comp a b)); opUnfoldBoolFormula; fail.

   (* HasBottom *)
   apply (opMap (@Lex.hasBottom a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.hasBottom_comp a b)); opUnfoldBoolFormula; fail.

   (* Total *)
   apply (opMap (@Lex.total a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.total_comp a b)); opUnfoldBoolFormula; fail.

   (* Antisym *)
   apply (opMap (@Lex.antisym a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.antisym_comp a b)); opUnfoldBoolFormula; fail.
Defined.
