Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Constructions.Preorders.Dual.
Require Import Metarouting.Inference.Common.Common.

Definition dualPreorder_props {a} (ap : poProp a) : poProp (dualPreorder a).
   intros; 
   apply (Build_poProp (dualPreorder a) ap);
   hypPropSplit.
   
   (* HasTop *)
   apply (opMap (@Dual.hasTop a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.hasTop_comp a)); opUnfoldBoolFormula; fail.

   (* HasBottom *)
   apply (opMap (@Dual.hasBottom a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.hasBottom_comp a)); opUnfoldBoolFormula; fail.

   (* Total *)
   apply (opMap (@Dual.total a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.total_comp a)); opUnfoldBoolFormula; fail.

   (* Antisym *)
   apply (opMap (@Dual.antisym a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.antisym_comp a)); opUnfoldBoolFormula; fail.
Defined.
