Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Preorders.RightNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.RightNaturalOrder.

Definition rightNaturalOrder_props {a} (ap : sgProp a) idem (comm : IsCommutative a) : osProp (rightNaturalOrder a idem).
   intros.
   apply (Build_osProp (rightNaturalOrder a idem) 
      (projSmgOSmgIso _ _ _ ap)
      (projProOSmgIso _ _ _ (rightNaturalOrder_props ap idem comm)));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opInit (@RightNaturalOrder.leftMonotonic a idem comm)).
   apply None.

   (* RightMonotonic *)
   apply (opInit (@RightNaturalOrder.rightMonotonic a idem comm)).
   apply None.
   
   (* TopIsAnnihilator *)
   apply (opInit (@RightNaturalOrder.topIsAnnihilator a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* TopIsIdentity *)
   apply (opMap (@RightNaturalOrder.topIsIdentity a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.topIsIdentity_comp a idem)); opUnfoldBoolFormula; fail.

   (* BottomIsAnnihilator *)
   apply (opMap (@RightNaturalOrder.bottomIsAnnihilator a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.bottomIsAnnihilator_comp a idem)); opUnfoldBoolFormula; fail.

   (* BottomIsIdentity *)
   apply (opInit (@RightNaturalOrder.bottomIsIdentity a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* LeftOpNonDecreasing *)
   apply (opInit (@RightNaturalOrder.leftOpNonDecreasing a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* RightOpNonDecreasing *)
   apply (opInit (@RightNaturalOrder.rightOpNonDecreasing a idem comm)); opUnfoldBoolFormula; fail.
   apply None.

   (* SelectiveOpNonDecreasing *)
   apply (opInit (@RightNaturalOrder.selectiveOpNonDecreasing a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* LeftOpIncreasing *)
   apply None.
   apply (opInit (@RightNaturalOrder.leftOpIncreasing_comp a idem)).

   (* RightOpIncreasing *)
   apply None.
   apply (opInit (@RightNaturalOrder.rightOpIncreasing_comp a idem)).

   (* LeftCancelative *)
   apply (opMap (@RightNaturalOrder.leftEquivCancelative a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.leftEquivCancelative_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@RightNaturalOrder.rightEquivCancelative a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.rightEquivCancelative_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@RightNaturalOrder.leftEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.leftEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@RightNaturalOrder.rightEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@RightNaturalOrder.rightEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* IncompArrowUniqueSrc *)
   apply (opInit (@RightNaturalOrder.incompArrowUniqueSrc a idem)).
   apply None.

   (* IncompArrowFactor *)
   apply (opInit (@RightNaturalOrder.incompArrowFactor a idem)).
   apply None.
Defined.
