Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Preorders.Lex.
Require Import Metarouting.Inference.Semigroups.Product.
Require Import Metarouting.Constructions.OrderSemigroups.Lex.

Definition lexOrderSemigroup_props {a} {b} (ap : osProp a) (bp : osProp b) : osProp (lexOrderSemigroup a b).
   intros.
   apply (Build_osProp (lexOrderSemigroup a b)
      (projSmgOSmgIso _ _ _ (prodSemigroup_props ap bp))
      (projProOSmgIso _ _ _ (lexPreorder_props ap bp)));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opMap (@Lex.leftMonotonic a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftMonotonic_comp a b)); opUnfoldBoolFormula; fail.

   (* RightMonotonic *)
   apply (opMap (@Lex.rightMonotonic a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightMonotonic_comp a b)); opUnfoldBoolFormula; fail.
   
   (* TopIsAnnihilator *)
   apply (opMap (@Lex.topIsAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.topIsAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* TopIsIdentity *)
   apply (opMap (@Lex.topIsIdentity a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.topIsIdentity_comp a b)); opUnfoldBoolFormula; fail.

   (* BottomIsAnnihilator *)
   apply (opMap (@Lex.bottomIsAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.bottomIsAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* BottomIsIdentity *)
   apply (opMap (@Lex.bottomIsIdentity a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.bottomIsIdentity_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftOpNonDecreasing *)
   apply (opMap (@Lex.leftOpNonDecreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftOpNonDecreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* RightOpNonDecreasing *)
   apply (opMap (@Lex.rightOpNonDecreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightOpNonDecreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* SelectiveOpNonDecreasing *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* LeftOpIncreasing *)
   apply (opMap (@Lex.leftOpIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftOpIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* RightOpIncreasing *)
   apply (opMap (@Lex.rightOpIncreasing a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightOpIncreasing_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@Lex.leftEquivCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftEquivCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@Lex.rightEquivCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightEquivCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@Lex.leftEquivCondensed a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftEquivCondensed_comp a b)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@Lex.rightEquivCondensed a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightEquivCondensed_comp a b)); opUnfoldBoolFormula; fail.

   (* IncompArrowUniqueSrc *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IncompArrowFactor *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
Defined.
