Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.
Require Import Metarouting.Inference.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.LeftNaturalOrder.

Definition leftNaturalOrder_props {a} (ap : sgProp a) idem (comm : IsCommutative a) : osProp (leftNaturalOrder a idem).
   intros.
   apply (Build_osProp (leftNaturalOrder a idem) 
      (projSmgOSmgIso _ _ _ ap)
      (projProOSmgIso _ _ _ (leftNaturalOrder_props ap idem comm)));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opInit (@LeftNaturalOrder.leftMonotonic a idem comm)).
   apply None.

   (* RightMonotonic *)
   apply (opInit (@LeftNaturalOrder.rightMonotonic a idem comm)).
   apply None.
   
   (* TopIsAnnihilator *)
   apply (opMap (@LeftNaturalOrder.topIsAnnihilator a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.topIsAnnihilator_comp a idem)); opUnfoldBoolFormula; fail.

   (* TopIsIdentity *)
   apply (opInit (@LeftNaturalOrder.topIsIdentity a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* BottomIsAnnihilator *)
   apply (opInit (@LeftNaturalOrder.bottomIsAnnihilator a idem)); opUnfoldBoolFormula; fail.
   apply None.

   (* BottomIsIdentity *)
   apply (opMap (@LeftNaturalOrder.bottomIsIdentity a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.bottomIsIdentity_comp a idem)); opUnfoldBoolFormula; fail.

   (* LeftOpNonDecreasing *)
   apply (opMap (@LeftNaturalOrder.leftOpNonDecreasing a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.leftOpNonDecreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightOpNonDecreasing *)
   apply (opMap (@LeftNaturalOrder.rightOpNonDecreasing a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.rightOpNonDecreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* SelectiveOpNonDecreasing *)
   apply (opMap (@LeftNaturalOrder.selectiveOpNonDecreasing a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.selectiveOpNonDecreasing_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* LeftOpIncreasing *)
   apply None.
   apply (opInit (@LeftNaturalOrder.leftOpIncreasing_comp a idem)).

   (* RightOpIncreasing *)
   apply None.
   apply (opInit (@LeftNaturalOrder.rightOpIncreasing_comp a idem)).

   (* LeftCancelative *)
   apply (opMap (@LeftNaturalOrder.leftEquivCancelative a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.leftEquivCancelative_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@LeftNaturalOrder.rightEquivCancelative a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.rightEquivCancelative_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@LeftNaturalOrder.leftEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.leftEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@LeftNaturalOrder.rightEquivCondensed a idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@LeftNaturalOrder.rightEquivCondensed_comp a idem comm)); opUnfoldBoolFormula; fail.

   (* IncompArrowUniqueSrc *)
   apply (opInit (@LeftNaturalOrder.incompArrowUniqueSrc a idem comm)).
   apply None.

   (* IncompArrowFactor *)
   apply (opInit (@LeftNaturalOrder.incompArrowFactor a idem comm)).
   apply None.
Defined.
