Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Preorders.Dual.
Require Import Metarouting.Constructions.OrderSemigroups.Dual.

Definition dualOrderSemigroup_props {a} (ap : osProp a) : osProp (dualOrderSemigroup a).
   intros.
   apply (Build_osProp (dualOrderSemigroup a) 
         (projSmgOSmgIso _ _ _ ap)
         (projProOSmgIso _ _ _ (dualPreorder_props ap)));
   hypPropSplit.
   
   (* LeftMonotonic *)
   apply (opMap (@Dual.leftMonotonic a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.leftMonotonic_comp a)); opUnfoldBoolFormula; fail.

   (* RightMonotonic *)
   apply (opMap (@Dual.rightMonotonic a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.rightMonotonic_comp a)); opUnfoldBoolFormula; fail.
   
   (* TopIsAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
   (* apply (opMap (@Dual.topIsAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.topIsAnnihilator_comp a)); opUnfoldBoolFormula; fail. *)

   (* TopIsIdentity *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
   (* apply (opMap (@Dual.topIsIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.topIsIdentity_comp a)); opUnfoldBoolFormula; fail. *)

   (* BottomIsAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
   (* apply (opMap (@Dual.bottomIsAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.bottomIsAnnihilator_comp a)); opUnfoldBoolFormula; fail. *)

   (* BottomIsIdentity *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
   (* apply (opMap (@Dual.bottomIsIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.bottomIsIdentity_comp a)); opUnfoldBoolFormula; fail. *)

   (* LeftNonDecreasing *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* RightNonDecreasing *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* SelectiveNonDecreasing *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* LeftIncreasing *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* RightIncreasing *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* LeftCancelative *)
   apply (opMap (@Dual.leftEquivCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.leftEquivCancelative_comp a)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@Dual.rightEquivCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.rightEquivCancelative_comp a)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@Dual.leftEquivCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.leftEquivCondensed_comp a)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@Dual.rightEquivCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Dual.rightEquivCondensed_comp a)); opUnfoldBoolFormula; fail.
   
   (* IncompArrowUniqueSrc *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IncompArrowFactor *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
Defined.
