Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.SelLex.
Require Import Metarouting.Inference.Semigroups.Product.
Require Import Metarouting.Constructions.Bisemigroups.SelLex.

Definition selLexBisemigroup_props {a} (ap : bsProp a) {b} (bp : bsProp b) comm sel (B_comm : IsCommutative (plusSmg b)) : bsProp (selLexBisemigroup a b comm sel).
   intros.
   apply (Build_bsProp (selLexBisemigroup a b comm sel)
         (projPlusBSmgIso _ _ _ (selLexSemigroup_props comm sel (bs_plus_sgprop _ ap) (bs_plus_sgprop _ bp)))
         (projTimesBSmgIso _ _ _ (prodSemigroup_props (bs_times_sgprop _ ap) (bs_times_sgprop _ bp))));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@SelLex.isLeftDistributive a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeftDistributive_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@SelLex.isRightDistributive a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRightDistributive_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opMap (@SelLex.plusIdentityIsTimesAnnihilator a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.plusIdentityIsTimesAnnihilator_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@SelLex.plusAnnihilatorIsTimesIdentity a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.plusAnnihilatorIsTimesIdentity_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply (opMap (@SelLex.isRightStrictStable a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRightStrictStable_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsLeftStrictStable *)
   apply (opMap (@SelLex.isLeftStrictStable a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeftStrictStable_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsRightCompEqCancel *)
   apply (opMap (@SelLex.isRightCompEqCancel a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRightCompEqCancel_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@SelLex.isLeftCompEqCancel a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeftCompEqCancel_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@SelLex.isRightCompCancel a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRightCompCancel_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@SelLex.isLeftCompCancel a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeftCompCancel_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply (opMap (@SelLex.leftDiscrete a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftDiscrete_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* RightDiscrete *)
   apply (opMap (@SelLex.rightDiscrete a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightDiscrete_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* LeftComparable *)
   apply (opMap (@SelLex.leftComparable a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftComparable_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@SelLex.rightComparable a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightComparable_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@SelLex.leftIncreasing a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftIncreasing_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@SelLex.rightIncreasing a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightIncreasing_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply (opMap (@SelLex.leftStrictIncreasing a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.leftStrictIncreasing_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* RightStrictIncreasing *)
   apply (opMap (@SelLex.rightStrictIncreasing a b comm sel B_comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.rightStrictIncreasing_comp a b comm sel B_comm)); opUnfoldBoolFormula; fail.

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opMap (@SelLex.isRightTimesMapToIdConstantPlus a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isRightTimesMapToIdConstantPlus_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opMap (@SelLex.isLeftTimesMapToIdConstantPlus a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.isLeftTimesMapToIdConstantPlus_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opMap (@SelLex.plusIdentityIsTimesLeftAnnihilator a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.plusIdentityIsTimesLeftAnnihilator_comp a b comm sel)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@SelLex.plusIdentityIsTimesRightAnnihilator a b comm sel)); opUnfoldBoolFormula; fail.
   apply (opMap (@SelLex.plusIdentityIsTimesRightAnnihilator_comp a b comm sel)); opUnfoldBoolFormula; fail.
Defined.
