Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.RevOp.
Require Import Metarouting.Constructions.Bisemigroups.RevTimes.

Definition revTimesBisemigroup_props {a} (ap : bsProp a) : bsProp (revTimesBisemigroup a).
   intros.
   apply (Build_bsProp (revTimesBisemigroup a)
         (bs_plus_sgprop _ ap)
         (projTimesBSmgIso _ _ _ (revOpSemigroup_props (bs_times_sgprop _ ap) )));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@RevTimes.isLeftDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isLeftDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@RevTimes.isRightDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isRightDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opMap (@RevTimes.plusIdentityIsTimesAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.plusIdentityIsTimesAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@RevTimes.plusAnnihilatorIsTimesIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.plusAnnihilatorIsTimesIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply (opMap (@RevTimes.isRightStrictStable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isRightStrictStable_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftStrictStable *)
   apply (opMap (@RevTimes.isLeftStrictStable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isLeftStrictStable_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompEqCancel *)
   apply (opMap (@RevTimes.isRightCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isRightCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@RevTimes.isLeftCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isLeftCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@RevTimes.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@RevTimes.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply (opMap (@RevTimes.leftDiscrete a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.leftDiscrete_comp a)); opUnfoldBoolFormula; fail.

   (* RightDiscrete *)
   apply (opMap (@RevTimes.rightDiscrete a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.rightDiscrete_comp a)); opUnfoldBoolFormula; fail.

   (* LeftComparable *)
   apply (opMap (@RevTimes.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@RevTimes.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@RevTimes.leftIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.leftIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@RevTimes.rightIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.rightIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply (opMap (@RevTimes.leftStrictIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.leftStrictIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightStrictIncreasing *)
   apply (opMap (@RevTimes.rightStrictIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.rightStrictIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opMap (@RevTimes.isRightTimesMapToIdConstantPlus a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isRightTimesMapToIdConstantPlus_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opMap (@RevTimes.isLeftTimesMapToIdConstantPlus a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.isLeftTimesMapToIdConstantPlus_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opMap (@RevTimes.plusIdentityIsTimesLeftAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.plusIdentityIsTimesLeftAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@RevTimes.plusIdentityIsTimesRightAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevTimes.plusIdentityIsTimesRightAnnihilator_comp a)); opUnfoldBoolFormula; fail.
Defined.
