Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.RangeMax.
Require Import Metarouting.Inference.Semigroups.RangeMin.
Require Import Metarouting.Inference.Bisemigroups.Unit.
Require Import Metarouting.Inference.Bisemigroups.BoolOrAnd.
Require Import Metarouting.Constructions.Bisemigroups.RangeMaxMin.

Definition rangeMaxMinBisemigroup_props n : bsProp (rangeMaxMinBisemigroup n).
   intros [|[|n]].
   apply (bsPropIso (BSmgIso_sym rmaxmin0BSmgIso) unitBisemigroup_props).
   apply (bsPropIso (BSmgIso_sym rmaxmin1BSmgIso) boolOrAndBisemigroup_props).

   apply (Build_bsProp (rangeMaxMinBisemigroup (S (S n)))
         (projPlusBSmgIso _ _ _  (rangeMaxSemigroup_props (S (S n))))
         (projTimesBSmgIso _ _ _ (rangeMinSemigroup_props (S (S n))))).

   (* IsLeftDistributive *)
   apply (opInit (@RangeMaxMin.isLeftDistributive (2 + n))).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@RangeMaxMin.isRightDistributive (2 + n))).
   apply None.

(*
   (* IsLeftCoDistributive *)
   apply (opInit (@RangeMaxMin.isLeftCoDistributive (2 + n))).
   apply None.

   (* IsRightCoDistributive *)
   apply (opInit (@RangeMaxMin.isRightCoDistributive (2 + n))).
   apply None.
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@RangeMaxMin.plusIdentityIsTimesAnnihilator (1 + n))).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@RangeMaxMin.plusAnnihilatorIsTimesIdentity (1 + n))).
   apply None.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@RangeMaxMin.isRightStrictStable_comp (1 + n))).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@RangeMaxMin.isLeftStrictStable_comp (1 + n))).

   (* IsRightCompEqCancel *)
   apply (opInit (@RangeMaxMin.isRightCompEqCancel (2 + n))).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opInit (@RangeMaxMin.isLeftCompEqCancel (2 + n))).
   apply None.

   (* IsRightCompCancel *)
   apply (opInit (@RangeMaxMin.isRightCompCancel (2 + n))).
   apply None.

   (* IsLeftCompCancel *)
   apply (opInit (@RangeMaxMin.isLeftCompCancel (2 + n))).
   apply None.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@RangeMaxMin.leftDiscrete_comp (1 + n))).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@RangeMaxMin.rightDiscrete_comp (1 + n))).

   (* LeftComparable *)
   apply (opInit (@RangeMaxMin.leftComparable (2 + n))).
   apply None.

   (* RightComparable *)
   apply (opInit (@RangeMaxMin.rightComparable (2 + n))).
   apply None.

   (* LeftIncreasing *)
   apply (opInit (@RangeMaxMin.leftIncreasing (2 + n))).
   apply None.

   (* RightIncreasing *)
   apply (opInit (@RangeMaxMin.rightIncreasing (2 + n))).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@RangeMaxMin.leftStrictIncreasing_comp (2 + n))).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@RangeMaxMin.rightStrictIncreasing_comp (2 + n))).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMaxMin.isRightTimesMapToIdConstantPlus_comp (1 + n))).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@RangeMaxMin.isLeftTimesMapToIdConstantPlus_comp (1 + n))).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@RangeMaxMin.plusIdentityIsTimesLeftAnnihilator (1 + n))).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@RangeMaxMin.plusIdentityIsTimesRightAnnihilator (1 + n))).
   apply None.
Defined.
