Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Lex.
Require Import Metarouting.Inference.Semigroups.Product.
Require Import Metarouting.Constructions.Bisemigroups.Lex.

Definition lexBisemigroup_props {a} {b} (ap : bsProp a) (bp : bsProp b) comm idem hasId : bsProp (lexBisemigroup a b hasId comm idem).
   intros.
   apply (Build_bsProp (lexBisemigroup a b hasId comm idem)
         (projPlusBSmgIso _ _ _ (lexSemigroup_props comm idem hasId (bs_plus_sgprop _ ap) (bs_plus_sgprop _ bp)))
         (projTimesBSmgIso _ _ _ (prodSemigroup_props (bs_times_sgprop _ ap) (bs_times_sgprop _ bp))));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@Lex.isLeftDistributive a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeftDistributive_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@Lex.isRightDistributive a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRightDistributive_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

(*
   (* IsLeftCoDistributive *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsRightCoDistributive *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opMap (@Lex.plusIdentityIsTimesAnnihilator a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.plusIdentityIsTimesAnnihilator_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@Lex.plusAnnihilatorIsTimesIdentity a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.plusAnnihilatorIsTimesIdentity_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply (opMap (@Lex.isRightStrictStable a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRightStrictStable_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsLeftStrictStable *)
   apply (opMap (@Lex.isLeftStrictStable a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeftStrictStable_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsRightCompEqCancel *)
   apply (opMap (@Lex.isRightCompEqCancel a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRightCompEqCancel_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@Lex.isLeftCompEqCancel a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeftCompEqCancel_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@Lex.isRightCompCancel a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRightCompCancel_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@Lex.isLeftCompCancel a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeftCompCancel_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply (opMap (@Lex.leftDiscrete a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftDiscrete_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* RightDiscrete *)
   apply (opMap (@Lex.rightDiscrete a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightDiscrete_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* LeftComparable *)
   apply (opMap (@Lex.leftComparable a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftComparable_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@Lex.rightComparable a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightComparable_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@Lex.leftIncreasing a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftIncreasing_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@Lex.rightIncreasing a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightIncreasing_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply (opMap (@Lex.leftStrictIncreasing a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.leftStrictIncreasing_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* RightStrictIncreasing *)
   apply (opMap (@Lex.rightStrictIncreasing a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.rightStrictIncreasing_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opMap (@Lex.isRightTimesMapToIdConstantPlus a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isRightTimesMapToIdConstantPlus_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opMap (@Lex.isLeftTimesMapToIdConstantPlus a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.isLeftTimesMapToIdConstantPlus_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opMap (@Lex.plusIdentityIsTimesLeftAnnihilator a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.plusIdentityIsTimesLeftAnnihilator_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@Lex.plusIdentityIsTimesRightAnnihilator a b hasId comm idem)); opUnfoldBoolFormula; fail.
   apply (opMap (@Lex.plusIdentityIsTimesRightAnnihilator_comp a b hasId comm idem)); opUnfoldBoolFormula; fail.
Defined.
