Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.FSetsUnion.
Require Import Metarouting.Inference.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Bisemigroups.FSetsOp.

Definition fsetOpBisemigroup_props {a} (ap : sgProp a) : bsProp (fsetOpBisemigroup a).
   intros.
   apply (Build_bsProp (fsetOpBisemigroup a)
         (projPlusBSmgIso _ _ _ (fsetsUnionSemigroup_props ap))
         (projTimesBSmgIso _ _ _ (fsetOpSemigroup_props ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opInit (@FSetsOp.isLeftDistributive a)).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@FSetsOp.isRightDistributive a)).
   apply None.

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@FSetsOp.plusIdentityIsTimesAnnihilator a)).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@FSetsOp.plusAnnihilatorIsTimesIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.plusAnnihilatorIsTimesIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@FSetsOp.isRightStrictStable_comp a)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@FSetsOp.isLeftStrictStable_comp a)).

   (* IsRightCompEqCancel *)
   apply (opMap (@FSetsOp.isRightCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.isRightCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@FSetsOp.isLeftCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.isLeftCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@FSetsOp.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@FSetsOp.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@FSetsOp.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@FSetsOp.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@FSetsOp.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@FSetsOp.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@FSetsOp.leftIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.leftIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@FSetsOp.rightIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSetsOp.rightIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@FSetsOp.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@FSetsOp.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@FSetsOp.isRightTimesMapToIdConstantPlus_comp a)).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@FSetsOp.isLeftTimesMapToIdConstantPlus_comp a)).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@FSetsOp.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@FSetsOp.plusIdentityIsTimesRightAnnihilator a)).
   apply None.
Defined.
