Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoidPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.FSetsUnion.
Require Import Metarouting.Inference.Semigroups.FSetsIntersect.
Require Import Metarouting.Constructions.Bisemigroups.FSets.

Definition fsetBisemigroup_props {a} (ap : dsProp a) : bsProp (fsetBisemigroup a).
   intros.
   apply (Build_bsProp (fsetBisemigroup a)
         (projPlusBSmgIso _ _ _ (fsetsUnionSemigroup_props ap))
         (projTimesBSmgIso _ _ _ (fsetsIntersectionSemigroup_props ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opInit (@FSets.isLeftDistributive a)).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@FSets.isRightDistributive a)).
   apply None.

(*
   (* IsLeftCoDistributive *)
   apply (opInit (@FSets.isLeftCoDistributive a)).
   apply None.

   (* IsRightCoDistributive *)
   apply (opInit (@FSets.isRightCoDistributive a)).
   apply None.
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@FSets.plusIdentityIsTimesAnnihilator a)).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@FSets.plusAnnihilatorIsTimesIdentity a)); opUnfoldBoolFormula; fail.
   apply None.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@FSets.isRightStrictStable_comp a)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@FSets.isLeftStrictStable_comp a)).

   (* IsRightCompEqCancel *)
   apply (opMap (@FSets.isRightCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.isRightCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@FSets.isLeftCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.isLeftCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@FSets.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@FSets.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@FSets.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@FSets.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@FSets.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@FSets.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@FSets.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opInit (@FSets.leftIncreasing a)).
   apply None.

   (* RightIncreasing *)
   apply (opInit (@FSets.rightIncreasing a)).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@FSets.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@FSets.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@FSets.isRightTimesMapToIdConstantPlus_comp a)).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@FSets.isLeftTimesMapToIdConstantPlus_comp a)).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@FSets.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@FSets.plusIdentityIsTimesRightAnnihilator a)).
   apply None.
Defined.
