Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.FMinSetUnion.
Require Import Metarouting.Inference.Semigroups.FMinSetsOp.
Require Import Metarouting.Constructions.Bisemigroups.FMinSetsOpUnion.

Definition minsetOpUnionBisemigroup_props {a} (ap : osProp a) lmon rmon antisym : bsProp (minsetOpUnionBisemigroup a lmon rmon antisym).
   intros.
   apply (Build_bsProp (minsetOpUnionBisemigroup a lmon rmon antisym)
         (projPlusBSmgIso _ _ _ (msetOpSemigroup_props lmon rmon antisym ap))
         (projTimesBSmgIso _ _ _ (msetUnionSemigroup_props antisym ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@FMinSetsOpUnion.isLeftDistributive a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.isLeftDistributive_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@FMinSetsOpUnion.isRightDistributive a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.isRightDistributive_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@FMinSetsOpUnion.plusAnnihilatorIsTimesIdentity a lmon rmon antisym)).
   apply None.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.isRightStrictStable_comp a lmon rmon antisym)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.isLeftStrictStable_comp a lmon rmon antisym)).

   (* IsRightCompEqCancel *)
   apply (opMap (@FMinSetsOpUnion.isRightCompEqCancel a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.isRightCompEqCancel_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@FMinSetsOpUnion.isLeftCompEqCancel a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.isLeftCompEqCancel_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsLeftCompCancel *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.leftDiscrete_comp a lmon rmon antisym)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.rightDiscrete_comp a lmon rmon antisym)).

   (* LeftComparable *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* RightComparable *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

  (* LeftIncreasing *)
   apply (opMap (@FMinSetsOpUnion.leftIncreasing a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.leftIncreasing_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@FMinSetsOpUnion.rightIncreasing a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSetsOpUnion.rightIncreasing_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.leftStrictIncreasing_comp a lmon rmon antisym)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@FMinSetsOpUnion.rightStrictIncreasing_comp a lmon rmon antisym)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
Defined.
