Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Union.
Require Import Metarouting.Inference.Semigroups.UnionSwap.
Require Import Metarouting.Inference.Semigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.AddOne.

Definition addOneBisemigroup_props {a} (ap : bsProp a) (comm : IsCommutative (plusSmg a)) : bsProp (addOneBisemigroup a).
   intros.
   apply (Build_bsProp (addOneBisemigroup a)
         (projPlusBSmgIso _ _ _ (unionSemigroup_props unitSemigroup_props (bs_plus_sgprop _ ap) ))
         (projTimesBSmgIso _ _ _ (unionSwapSemigroup_props (bs_times_sgprop _ ap) unitSemigroup_props)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@AddOne.isLeftDistributive a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isLeftDistributive_comp a comm)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@AddOne.isRightDistributive a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isRightDistributive_comp a comm)); opUnfoldBoolFormula; fail.

(*
   (* IsLeftCoDistributive *)
   apply (opMap (@AddOne.isLeftCoDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isLeftCoDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCoDistributive *)
   apply (opMap (@AddOne.isRightCoDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isRightCoDistributive_comp a)); opUnfoldBoolFormula; fail.
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opMap (@AddOne.plusIdentityIsTimesAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.plusIdentityIsTimesAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@AddOne.plusAnnihilatorIsTimesIdentity a)).
   apply None.

   (* IsRightStrictStable *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsLeftStrictStable *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsRightCompEqCancel *)
   apply (opMap (@AddOne.isRightCompEqCancel a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isRightCompEqCancel_comp a comm)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@AddOne.isLeftCompEqCancel a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isLeftCompEqCancel_comp a comm)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@AddOne.isRightCompCancel a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isRightCompCancel_comp a comm)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@AddOne.isLeftCompCancel a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.isLeftCompCancel_comp a comm)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@AddOne.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@AddOne.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@AddOne.leftComparable a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.leftComparable_comp a comm)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@AddOne.rightComparable a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.rightComparable_comp a comm)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@AddOne.leftIncreasing a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.leftIncreasing_comp a comm)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@AddOne.rightIncreasing a comm)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.rightIncreasing_comp a comm)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@AddOne.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@AddOne.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@AddOne.isRightTimesMapToIdConstantPlus_comp a)).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@AddOne.isLeftTimesMapToIdConstantPlus_comp a)).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opMap (@AddOne.plusIdentityIsTimesLeftAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.plusIdentityIsTimesLeftAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@AddOne.plusIdentityIsTimesRightAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddOne.plusIdentityIsTimesRightAnnihilator_comp a)); opUnfoldBoolFormula; fail.
Defined.
