Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Signatures.IdArrow.
(*Require Import Metarouting.Categories.Category.*)

Section Union.
   
   (* We cannot take Transforms directly as arguments here,
    * since we need their setoids to be equal. If this equality
    * is given as an argument to the section, we would need
    * to use it in every proof. In this situation, it is better
    * to take separate parts of Transform with only one setoid.
    * Consider two transforms:
    *    (D, F, app_f, app_pres_eq_f)
    *    (D, G, app_g, app_pres_eq_g)
    *)
   Variable D F G : DecSetoid.
   Variable app_f : F -> D -> D.
   Variable app_g : G -> D -> D.
   Variable app_pres_eq_f : AppPreserve app_f.
   Variable app_pres_eq_g : AppPreserve app_g.
   
   Open Scope Transform_scope.
   
   Definition union_app (f : unionDecSetoid F G) (x : D) : D :=
      match f with
         | inl f => app_f f x
         | inr g => app_g g x
      end.

   Lemma union_app_pres_eq : AppPreserve union_app.
   Proof. intros x y [f|f] [g|g] h p; simpl. apply (app_pres_eq_f); auto.
      discriminate p. 
      discriminate p.
      apply (app_pres_eq_g); auto.
   Defined.

   Definition unionTransform_DsEq : Transform :=
      Build_Transform union_app_pres_eq.

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Local Notation A := (Build_Transform app_pres_eq_f).
   Local Notation B := (Build_Transform app_pres_eq_g).

   Lemma cancelative : Cancelative A * Cancelative B -> Cancelative unionTransform_DsEq.
   Proof. intros [ca cb] x y [f|f]; simpl. apply ca. apply cb. Defined.

   Lemma cancelative_comp : Cancelative_comp A + Cancelative_comp B -> Cancelative_comp unionTransform_DsEq.
   Proof. intros [[x [y [f [p1 p2]]]] | [x [y [f [p1 p2]]]]]; simpl.
      exists x; exists y; exists (inl _ f). simpl; split; auto.
      exists x; exists y; exists (inr _ f). simpl; split; auto.
   Defined.
   
   Lemma condensed : Condensed A * Condensed B -> Condensed unionTransform_DsEq.
   Proof. intros [ca cb] x y [f|f]; simpl. apply ca. apply cb. Defined.

   Lemma condensed_comp : Condensed_comp A + Condensed_comp B -> Condensed_comp unionTransform_DsEq.
   Proof. intros [[x [y [f p]]] | [x [y [f p]]]].
      exists x; exists y; exists (inl _ f); simpl; trivial.
      exists x; exists y; exists (inr _ f); simpl; trivial.
   Defined.
   
   Lemma identity : Identity A * Identity B -> Identity unionTransform_DsEq.
   Proof. intros [iida iidb] x [f|f]. simpl. apply iida. simpl; apply iidb. Qed.

   Lemma identity_comp : Identity_comp A + Identity_comp B -> Identity_comp unionTransform_DsEq.
   Proof. intros [[x [f iid]] | [x [f iid]]].
      exists x; exists (inl _ f). apply iid.
      exists x; exists (inr _ f); apply iid.
   Defined.

   Close Scope Transform_scope.

End Union.

Section UnionEq.

   Variable A B : Transform.
   Variable f : DsIso A B.
   
   Definition unionTransform : Transform.
      set (D := setoid A).
      destruct A as [setoidA fnA appA app_pres_eqA];
      destruct B as [setoidB fnB appB app_pres_eqB];
      simpl in *.
      set (appB2 := fun l x => phi' f (appB l (phi f x))).
      apply (unionTransform_DsEq D fnA fnB appA appB2).
      intros x y m n; apply (app_pres_eqA x y m n).
      red; simpl in *.
      intros x y m n p q. unfold appB2. unfold D in *; clear D.
      apply (pres_eq' f). apply app_pres_eqB; auto. rewrite p. auto.
(*      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      simpl in *.
      set (appB2 := fun l x => phi' f (appB l (phi f x))).
      apply (unionTransform_DsEq D fnA fnB appA appB2).
      intros x y m n; apply (app_pres_eqA x y m n).
      red; simpl in *.
      intros x y m n p q. unfold appB2. unfold D in *; clear D.
      apply (pres_eq' f). apply app_pres_eqB; auto. rewrite p. auto.*)
   Defined.
   
End UnionEq.

(*
Section UnionEq_PresEq.
   
   (* A ==ds== B *)
   Variable A B : Transform.
   Variable ab : IdDsIso A B.
   
   (* C ==ds== D *)
   Variable C D : Transform.
   Variable cd : IdDsIso C D.
   
   Definition UT1 := unionTransform A B ab.
   Definition UT2 := unionTransform C D cd.
   
   (* A ==tr== C *)
   Variable ac : IdTfIso A C.

   (* B ==tr== D *)
   Variable bd : IdTfIso B D.

   
   (*       ds
       A -------> B
       |          |
   tr  |          | tr     <=== We really need this diagram to commute. 
       |          |
       v          v
       C -------> D
            ds
   *)

   
   Definition ut_12 : UT1 -> UT2.
      intros x.
      unfold UT1, UT2 in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      apply (phi ac x).
   Defined.
   
   Definition ut_21 : UT2 -> UT1.
      intros x.
      unfold UT1, UT2 in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      apply (phi' ac x).
   Defined.
   
   Definition ut_f12 : fn UT1 -> fn UT2.
      intros x.
      unfold UT1, UT2 in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct x as [x|x].
         apply inl; apply (phi (fnIso ac) x).
         apply inr; apply (phi (fnIso bd) x).
   Defined.

   Definition ut_f21 : fn UT2 -> fn UT1.
      intros x.
      unfold UT1, UT2 in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct x as [x|x].
         apply inl; apply (phi' (fnIso ac) x).
         apply inr; apply (phi' (fnIso bd) x).
   Defined.

   Lemma ut_dsIso : DsIso UT1 UT2.
   Proof. split with ut_12 ut_21; split;
      unfold UT1, UT2, ut_12, ut_21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      
      intros x y p; rewrite p; auto.
      intros x y p; rewrite p; auto.
      intros x; rewrite (inv ac); auto.
      intros x; rewrite (inv' ac); auto.
   Defined.

   Lemma ut_fnIso : DsIso (fn UT1) (fn UT2).
   Proof. split with ut_f12 ut_f21; split;
      unfold UT1, UT2, ut_f12, ut_f21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      
      intros [x|x] [y|y] p; dseq_u; simpl in *; auto; dseq_f; rewrite p; auto.
      intros [x|x] [y|y] p; dseq_u; simpl in *; auto; dseq_f; rewrite p; auto.
      intros [x|x]; dseq_u; simpl; auto; dseq_f.
         rewrite (inv (fnIso ac)); auto.
         rewrite (inv (fnIso bd)); auto.
      intros [x|x]; dseq_u; simpl; auto; dseq_f.
         rewrite (inv' (fnIso ac)); auto.
         rewrite (inv' (fnIso bd)); auto.
   Defined.

   Lemma ut_tfIso : TfIso UT1 UT2.
   Proof. split with ut_dsIso ut_fnIso.
      split. intros f x.
      unfold ut_dsIso, ut_fnIso, UT1, UT2, ut_12, ut_21, ut_f12, ut_f21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct f as [f|f]; simpl.
         rewrite (Transform.pres_app ac); simpl; auto.
         rewrite isoMove'.
         assert (h1 := Transform.pres_app' bd). simpl in h1.
         match goal with
           |- ?X == ?Y => assert (phi' bd X == phi' bd Y) as h2
         end.
         rewrite h1.
         assert (forall y, phi' bd (phi cd (phi ac (phi' ab y))) = y).
            simpl. intros y. apply IsIdCancel4. apply bd. apply cd. apply ac. apply ab.
         rewrite H.
         apply app_pres_eqB.
            rewrite <- isoMove'. rewrite IsIdCancel4; auto.
               apply ab. apply bd. apply cd. apply ac.
            rewrite (inv' (fnIso bd)); auto.
         assert (h3 := DecSetoid.pres_eq bd h2); do 2 rewrite (inv bd) in h3; auto.
      
      intros f x.
      unfold ut_dsIso, ut_fnIso, UT1, UT2, ut_12, ut_21, ut_f12, ut_f21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct f as [f|f]; simpl.
         rewrite (Transform.pres_app' ac); simpl; auto.
         rewrite isoMove'.
         assert (h1 := Transform.pres_app bd). simpl in h1.
         match goal with
           |- ?X == ?Y => assert (phi bd X == phi bd Y) as h2
         end.
         rewrite h1.
         rewrite (IsIdCancel4 (phi bd) (phi ab) (phi' ac) (phi' cd));
            [| apply bd | apply ab | apply ac | apply cd ].
         apply app_pres_eqD.
         rewrite <- isoMove'.
         rewrite IsIdCancel4; [ auto | apply cd | apply bd | apply ab | apply ac ].
         rewrite (inv (fnIso bd)); auto.
         assert (h3 := DecSetoid.pres_eq' bd h2); do 2 rewrite (inv' bd) in h3; auto.
   Defined.
   
   Lemma ut_pres_idIso : IdTfIso UT1 UT2.
   Proof. split with ut_tfIso; split; simpl.
      (* ut_12 *)
      repeat unfold UT1, UT2, ut_12, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct ac as [[[ac_phi ac_phi'] ac_fnIso] [ac_id ac_id']]; simpl in *.
      destruct ac_id. split. intros x; apply (H x).

      (* ut_21 *)
      repeat unfold UT1, UT2, ut_21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct ac as [[[ac_phi ac_phi'] ac_fnIso] [ac_id ac_id']]; simpl in *.
      destruct ac_id'. split. intros x; apply (H x).

      (* ut_f12 *)
      repeat unfold UT1, UT2, ut_f12, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id. destruct bd_id. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.

      (* ut_f21 *)
      repeat unfold UT1, UT2, ut_f21, unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id'. destruct bd_id'. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.
   Qed.

End UnionEq_PresEq.

Section DsUnionFunctor.
   Open Scope Category_scope.
   
   Definition dsunion_fob : ob (ProdCat DsCat DsCat) -> ob DsCat.
      intros [x y]. apply (unionDecSetoid x y).
   Defined.
   
   Definition dsunion_fhom : forall A B (f : (ProdCat DsCat DsCat)[A,B]), DsCat[dsunion_fob A, dsunion_fob B].
      intros [a1 a2] [b1 b2] [f1 f2]. unfold dsunion_fob; simpl.
      split with (fun x => match x with inl x => inl _ (f1 x) | inr x => inr _ (f2 x) end).
      split. intros [x|x] [y|y] p; dseq_u; simpl in *; dseq_f; auto.
      apply (pres_eq f1); auto.
      apply (pres_eq f2); auto.
   Defined.
   
   Definition dsUnionFunctor : Functor (ProdCat DsCat DsCat) DsCat.
      split with dsunion_fob dsunion_fhom.
      
      intros [a1 a2] [b1 b2] [f1 f2] [g1 g2] [p1 p2] [x|x]; unfold dsunion_fhom; dseq_u; simpl in *; dseq_f.
         apply (p1 x).
         apply (p2 x).
      intros [a1 a2] [x|x]; unfold dsunion_fhom; dseq_u; simpl in *; dseq_f; auto.
      intros [a1 a2] [b1 b2] [c1 c2] [f1 f2] [g1 g2] [x|x]; unfold dsunion_fhom; dseq_u; simpl in *; dseq_f; auto.
   Defined.
   
   Close Scope Category_scope.

End DsUnionFunctor.

Section TfUnionFunctor.

   Open Scope Category_scope.

   Definition tfunion_fob (x : ob unionArgCat) : ob TfCat.
      intros x. destruct x.
      apply (unionTransform_DsEq common fn1 fn2 app1 app2 app_pres_eq1 app_pres_eq2).
   Defined.
   
   Definition tfunion_fhom A B (f : unionArgCat[A,B]) : TfCat[tfunion_fob A, tfunion_fob B].
      intros A B f.
      destruct A; destruct B; destruct f; unfold tfunion_fob; simpl in *.
      set (fnDsHom := (fun x => match x with inl x => inl _ (fnf1 x) | inr x => inr _ (fnf2 x) end) 
                      : (unionDecSetoid fn1 fn2) -> (unionDecSetoid fn0 fn3)).
      assert (IsDsHom fnDsHom) as isFnDsHom.
         split. intros [x|x] [y|y] p; dseq_u; simpl in *; dseq_f; auto.
            apply (pres_eq fnf1); auto.
            apply (pres_eq fnf2); auto.
      split with uaf (Build_DsHom isFnDsHom).
      split. intros [f|f] x; simpl in *.
         apply (pres_app (pres_app1 isUnionArgHom)).
         apply (pres_app (pres_app2 isUnionArgHom)).
   Defined.
   
   Definition tfUnionFunctor : Functor unionArgCat TfCat.
      split with tfunion_fob tfunion_fhom.
      
      intros a b f g p x; simpl in *;
      destruct a; destruct b; destruct f; destruct g; destruct p; simpl in *; apply (uaf_eq x).
      
      intros a x; destruct a; simpl in *; auto.
      
      intros a b c f g x; simpl in *;
      destruct a; destruct b; destruct c; destruct f; destruct g; simpl in *;
      apply (pres_eq uaf); apply (pres_eq uaf0); auto.
   Defined.

End TfUnionFunctor.
*)