Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Constructions.DecSetoids.Product.

Section Product.

   Variable A B : Transform.

   Open Scope Transform_scope.
   
   Definition prod_app (f :prodDecSetoid (fn A) (fn B)) (x : prodDecSetoid A B) : prodDecSetoid A B :=
      let (x1, x2) := x in let (f1, f2) := f in
      (f1 |> x1, f2 |> x2).
      
   Lemma prod_app_pres_eq : AppPreserve prod_app.
   Proof. intros [x1 x2] [y1 y2] [f1 f2] [g1 g2]. dseq_u; simpl. toProp; dseq_f.
      intros [p1 p2] [q1 q2]; rewrite p1, p2, q1, q2; auto.
   Defined.
   
   Definition prodTransform : Transform :=
      Build_Transform prod_app_pres_eq.
         
   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : Cancelative A * Cancelative B -> Cancelative prodTransform.
   Proof. intros [ebf eaf] [x1 x2] [y1 y2] [f1 f2]. dseq_u; simpl; toProp; dseq_f.
      intros [h1 h2]; simpl; split; eauto.
   Defined.

   Lemma cancelative_comp : Cancelative_comp A + Cancelative_comp B -> Cancelative_comp prodTransform.
   Proof. intros [[x [y [f1 [p1 p2]]]]  | [x [y [f2 [p1 p2]]]]].
      exists (x, choose B); exists (y, choose B); exists (f1, choose (fn B)).
      dseq_u; simpl; negb_p; toProp; dseq_f; auto.
      exists (choose A, x); exists (choose A, y); exists (choose (fn A), f2).
      dseq_u; simpl; negb_p; toProp; dseq_f; auto.
   Defined.
   
   Lemma condensed : Condensed A * Condensed B -> Condensed prodTransform.
   Proof. intros [ebf eaf] [x1 x2] [y1 y2] [f1 f2]. dseq_u; simpl; toProp; dseq_f; auto. Defined.

   Lemma condensed_comp : Condensed_comp A + Condensed_comp B -> Condensed_comp prodTransform.
   Proof. intros [[x [y [f1 p]]] | [x [y [f2 p]]]].
      exists (x, choose B); exists (y, choose B); exists (f1, choose (fn B)); 
      dseq_u; simpl; negb_p; toProp; dseq_f; auto.
      exists (choose A, x); exists (choose A, y); exists (choose (fn A), f2);
      dseq_u; simpl; negb_p; toProp; dseq_f; auto.
   Defined.
	
   Lemma identity : Identity A * Identity B -> Identity prodTransform.
   Proof. intros [iida iidb] [x1 x2] [f1 f2]. dseq_u; simpl. toProp. dseq_f.
      split; auto.
   Qed.
   
   Lemma identity_comp : Identity_comp A + Identity_comp B -> Identity_comp prodTransform.
   Proof. intros [[x [f iid]] | [x [f iid]]].
      exists (x, choose B); exists (f, choose (fn B)); dseq_u; simpl. negb_p. toProp; auto.
      exists (choose A, x); exists (choose (fn A), f); dseq_u; simpl. negb_p. toProp; auto.
   Defined.

   Close Scope Transform_scope.

End Product.