Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.OrderTransformProperties.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Transforms.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section FMinSets.

   Variable A : OrderTransform.
   Variable mon : Monotone A.
   Variable antisym : Antisym A.

   Open Scope OrderTransform_scope.
   
   Definition mmap_app (f : fn A) (x : msetDecSetoid A) : msetDecSetoid A :=
      min A (fmap_app A f x).

   (****************************************************************)
   (*                 Reflection into upper sets                   *)
   (****************************************************************)
   
   Lemma upper_fmap_intro : forall a x f b, (f |> b) <= a -> upper_mem A b x -> upper_mem A a (fmap_app A f x).
   Proof. intros a x f b p q.
      destruct (upper_mem_elim A _ _ q) as [c [p1 p2]]; clear q.
      apply (upper_mem_intro2 antisym) with (f |> c).
      rewrite min_mem in p1.
      destruct p1 as [p1 p3].
      apply (mem_fmap_intro A); auto.
      simpl in *.
      apply le_trans with (f |> b).
         apply mon; auto.
         auto.
   Qed.

   Lemma upper_fmap_elim : forall a f x, upper_mem A a (fmap_app A f x) -> Exists b, f |> b <= a /\ upper_mem A b x.
   Proof. intros a f x p.
      destruct (upper_mem_elim A _ _ p) as [b [p1 p2]]; clear p. simpl in *.
      rewrite (min_mem A) in p1; destruct p1 as [p1 _].
      destruct (mem_fmap_elim A _ _ _ p1) as [c [p3 p4]]. simpl in *.
      exists c. split.
      rewrite p4; auto.
      apply (upper_mem_intro2 antisym) with c; auto.
   Qed.
   
   Lemma min_fmap : forall f x, min A (fmap_app A f x) == min A (fmap_app A f (min A x)).
   Proof. intros f x. rewrite <- (upper_eq antisym). intros a.
      rewrite bool_eq; split; intros h.
      destruct (upper_fmap_elim _ _ _ h) as [b [p1 p2]].
      destruct (upper_mem_elim A _ _ p2) as [c [p3 p4]]. simpl in *.
      apply upper_fmap_intro with c.
      apply le_trans with (f |> b); auto.
      apply (upper_mem_intro2 antisym) with c; auto.
      destruct (upper_fmap_elim _ _ _ h) as [b [p1 p2]].
      destruct (upper_mem_elim A _ _ p2) as [c [p3 p4]]. simpl in *.
      apply upper_fmap_intro with c.
      apply le_trans with (f |> b); auto.
      do 2 (rewrite (min_mem A) in p3; destruct p3 as [p3 _]).
      apply (upper_mem_intro2 antisym) with c; auto.
   Qed.

   Ltac toMSet :=
      unfold eq_mset in *;
      unfold mmap_app in *.
      
   Ltac toMSet_u :=
      dseq_u; simpl in *;
      toMSet.
      
   Lemma mmap_app_pres_eq : AppPreserve mmap_app.
   Proof. intros x y f g p q.
      toMSet_u. repeat rewrite (min_min A).
      rewrite (min_fmap f x), (min_fmap g y).
      apply min_pres_eq. apply (fmap_app_pres_eq A); auto.
   Qed.
   
   Definition msetsTransform : Transform :=
      Build_Transform mmap_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : Embedding A -> Cancelative msetsTransform.
   Proof. intros em x y f h. toMSet_u.
      repeat rewrite (min_min A) in *. dseq_f.
      (*rewrite <- (upper_eq antisym) in h.*)
      rewrite <- (upper_eq antisym); intros a.
      rewrite bool_eq; split; intros p.
      
      assert (upper_mem A (f |> a) (fmap_app A f x)) as p1.
         apply upper_fmap_intro with a; auto. apply le_refl.
      destruct (upper_mem_elim A _ _ p1) as [b [p2 p3]]. simpl in *.
      assert (mem b (min A (fmap_app A f y))) as p7.
         toSet_u. rewrite <- h; auto.
      rewrite (min_mem A) in p2; destruct p2 as [p2 p4]. simpl in *.
      destruct (mem_fmap_elim A _ _ _ p2) as [c [p5 p6]]. simpl in *.
      rewrite (min_mem A) in p7; destruct p7 as [p7 p8]. simpl in *.
      destruct (mem_fmap_elim A _ _ _ p7) as [d [p9 p10]]. simpl in *.
      rewrite <- p10 in p6.
      assert (c == d) as h1.
         apply antisym; split; simpl; apply (em mon) with f; rewrite p6; apply le_refl.
      apply (upper_mem_intro2 antisym) with d; auto.
         simpl. rewrite <- p10 in p3. apply (em mon) with f; auto.

      assert (upper_mem A (f |> a) (fmap_app A f y)) as p1.
         apply upper_fmap_intro with a; auto. apply le_refl.
      destruct (upper_mem_elim A _ _ p1) as [b [p2 p3]]. simpl in *.
      assert (mem b (min A (fmap_app A f x))) as p7.
         toSet_u. rewrite h; auto.
      rewrite (min_mem A) in p2; destruct p2 as [p2 p4]. simpl in *.
      destruct (mem_fmap_elim A _ _ _ p2) as [c [p5 p6]]. simpl in *.
      rewrite (min_mem A) in p7; destruct p7 as [p7 p8]. simpl in *.
      destruct (mem_fmap_elim A _ _ _ p7) as [d [p9 p10]]. simpl in *.
      rewrite <- p10 in p6.
      assert (c == d) as h1.
         apply antisym; split; simpl; apply (em mon) with f; rewrite p6; apply le_refl.
      apply (upper_mem_intro2 antisym) with d; auto.
         simpl. rewrite <- p10 in p3. apply (em mon) with f; auto.
   Qed.
   
   Lemma cancelative_comp : Embedding_comp A -> Cancelative_comp msetsTransform.
   Proof. intros em. destruct (em mon) as [x [y [f [p1 p2]]]].
      copy_destruct (y <= x).
      assert (f |> x == f |> y) as p.
         apply antisym; split; simpl; auto.
      exists (y :: nil); exists (x :: nil); exists f. split.
         simpl. toMSet_u. repeat rewrite (min_min A). dseq_f.
         unfold fmap_app; simpl.
         unfold min; simpl. negb_p; repeat rewrite le_refl; simpl.
         toSet_u. simpl. repeat rewrite orb_false_r.
         dseq_f; rewrite p. auto.
         
         toProp; intros h; toMSet_u. dseq_f; unfold min in h; simpl in h.
         negb_p; repeat rewrite le_refl in h; simpl in h.
         apply p2. toSet_u. assert (p3 := h x); simpl in p3.
         rewrite refl, orb_false_r in p3; simpl in p3. dseq_f; rewrite p3; apply le_refl.

      exists (x :: y :: nil); exists (x :: nil); exists f. split.
         simpl; toMSet_u; repeat rewrite (min_min A); dseq_f;
         unfold fmap_app; simpl.
         unfold min; simpl. negb_p; repeat rewrite le_refl; simpl.
         toSet_u. simpl. repeat rewrite orb_false_r.
         copy_destruct (f |> x == f |> y); rewrite ew0; simpl;
         negb_p; repeat rewrite le_refl; simpl.
         dseq_f; rewrite orb_false_r, ew0; auto.
         assert (f |> y <= f |> x = false) as p.
            bool_p; intros h; apply ew0; apply antisym; split; auto.
         rewrite p1, p; simpl; negb_p; repeat rewrite le_refl; simpl.
         rewrite orb_false_r; auto.

         toProp; intros h; dseq_f; toMSet_u. dseq_f; toSet_u.
         assert (p := h y); clear h.
         unfold min in p; simpl in p.
         negb_p; repeat rewrite le_refl in p; simpl in p.
         assert (x <= y = false) as p3.
            bool_p; auto.
         rewrite ew, p3 in p; simpl in p.
         rewrite refl, orb_true_r, orb_false_r in p.
         assert (y == x) as p4.
            dseq_u; rewrite <- p; auto.
         apply p2; rewrite p4; apply le_refl.
   Defined.

   Lemma condensed_comp : Condensed_comp msetsTransform.
   Proof. set (a := choose A); set (f := choose (fn A)).
      exists (a :: nil); exists nil; exists f.
      toProp; intros h; dseq_f. simpl in h. toMSet_u. repeat rewrite (min_min A) in h.
      dseq_f; toSet_u.
      assert (p := h (f |> a)); clear h.
      simpl in p.
      unfold fmap_app, min in p; simpl in p.
      negb_p; rewrite le_refl in p; simpl in p.
      rewrite refl in p; discriminate p.
   Defined.
   
   Lemma identity : Identity A -> Identity msetsTransform.
   Proof. intros iid x f.
      simpl. toMSet_u. rewrite (min_min A). dseq_f. rewrite <- (upper_eq antisym). intros a.
      rewrite bool_eq; split; intros h.
      destruct (upper_fmap_elim _ _ _ h) as [b [p1 p2]].
      destruct (upper_mem_elim A _ _ p2) as [c [p3 p4]]. simpl in *.
      apply upper_mem_intro2 with c; simpl; auto.
      rewrite (min_mem A) in p3; destruct p3; auto.
      rewrite (iid b f) in p1. apply le_trans with b; auto.
      
      destruct (upper_mem_elim A _ _ h) as [b [p1 p2]]. simpl in *.
      apply upper_mem_intro2 with b; simpl; auto.
      rewrite <- (mem_pres_eq _ (iid b f)).
      apply mem_fmap_intro; auto.
      rewrite (min_mem A) in p1; destruct p1; auto.
   Qed.
   
   Lemma identity_comp : Identity_comp A -> Identity_comp msetsTransform.
   Proof. intros [x [f iid]].
      exists (x :: nil); exists f. toProp; intros h; apply iid; clear iid.
      dseq_f; toMSet_u; rewrite (min_min A) in h; dseq_f; toSet_u.
      assert (p := h x); clear h.
      unfold min, fmap_app in p; simpl in p.
      negb_p; repeat rewrite le_refl in p; simpl in p.
      rewrite orb_false_r, refl in p; dseq_f; rewrite <- p; auto.
   Defined.

End FMinSets.