Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.

Section Cayley.

   Variable A : Semigroup.

   Open Scope Transform_scope.
   Open Scope Semigroup_scope.
   
   Definition cayley_app (f : A) (x : A) : A := f + x.
   
   Lemma cayley_app_pres_eq : AppPreserve cayley_app.
   Proof. intros x y f g p q. unfold cayley_app. rewrite p, q; auto. Qed.
   
   Definition cayleyMapTransform : Transform :=
      Build_Transform cayley_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : LeftCancelative A -> Cancelative cayleyMapTransform.
   Proof. intros lc x y f; simpl; unfold cayley_app. apply lc. Defined.

   Lemma cancelative_comp : LeftCancelative_comp A -> Cancelative_comp cayleyMapTransform.
   Proof. intros [a [b [c lc]]]; exists a; exists b; exists c; simpl. apply lc. Defined.

   Lemma condensed : LeftCondensed A -> Condensed cayleyMapTransform.
   Proof. intros lc x y f; simpl; unfold cayley_app. apply lc. Defined.
   
   Lemma condensed_comp : LeftCondensed_comp A -> Condensed_comp cayleyMapTransform.
   Proof. intros [a [b [c lc]]]; exists b; exists c; exists a; simpl. apply lc. Defined.
   
   Lemma identity : IsRight A -> Identity cayleyMapTransform.
   Proof. intros rt x f; simpl; unfold cayley_app; simpl; auto. Qed.

   Lemma identity_comp : IsRight_comp A -> Identity_comp cayleyMapTransform.
   Proof. intros [x [y rt]].
      exists y; exists x; simpl; unfold cayley_app; auto.
   Defined.

   Close Scope Transform_scope.
   
End Cayley.