Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Coq.Lists.List.

Section Postfix.

   Open Scope Semigroup_scope.

   Variable A : DecSetoid.
   
   Lemma rev_pres_eq : forall (x y : seqDecSetoid A), x == y -> @dseq (seqDecSetoid A) (rev x) (rev y).
   Proof. refine (fix rev_pres_eq (x y : seqDecSetoid A) (e : x == y) {struct x} : @dseq (seqDecSetoid A) (rev x) (rev y) := _).
      destruct x; destruct y; trivial; dseq_u; simpl in e; try discriminate.
      copy_destruct ((c == c0)%bool); rewrite ew in e; simpl in e; [|discriminate e].
      simpl.
      apply (app_pres_eq A). apply rev_pres_eq; auto.
      dseq_u; simpl; dseq_f. rewrite ew; auto.
   Qed.
   
   Lemma rev_embed : forall (x y : seqDecSetoid A), @dseq (seqDecSetoid A) (rev x) (rev y) -> x == y.
   Proof. intros x y p;
      rewrite <- (rev_involutive x), <- (rev_involutive y); apply rev_pres_eq; auto.
   Qed.
   
   Definition postfix (x y : seqDecSetoid A) : seqDecSetoid A :=
      rev (prefix A (rev x) (rev y)).
      
   Lemma postfix_assoc : Associative postfix.
   Proof. intros x y z. unfold postfix.
      apply rev_pres_eq.
      repeat rewrite rev_involutive.
      apply prefix_assoc.
   Qed.
   
   Lemma postfix_pres_eq : Preserves postfix.
   Proof. intros x y u v p q; unfold postfix.
      apply rev_pres_eq.
      apply prefix_pres_eq;
      apply rev_pres_eq; auto.
   Qed.
      
   Definition postfixSemigroup : Semigroup :=
      Build_Semigroup
         postfix_assoc (* assoc *)
         postfix_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Definition isoPostfixPrefixSemigroup_dsIso : DsIso (postfixSemigroup) (prefixSemigroup A).
      split with (@rev A) (@rev A).
      split.
      
      intros x y. apply (rev_pres_eq).
      intros x y. apply (rev_pres_eq).
      intros x; rewrite rev_involutive; auto.
      intros x; rewrite rev_involutive; auto.
   Defined.
   
   Definition isoPostfixPrefixSemigroup : SmgIso (postfixSemigroup) (prefixSemigroup A).
      split with isoPostfixPrefixSemigroup_dsIso.
      split.

      intros x y; simpl. unfold postfix; rewrite rev_involutive; auto.
      intros x y; simpl. unfold postfix; repeat rewrite rev_involutive; auto.
   Defined.

End Postfix.