Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Coq.Arith.Max.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Coq.Setoids.Setoid.
Require Import Metarouting.Constructions.DecSetoids.Nat.


(*********************************************************************)
(* decidable semigroups of natural numbers with max function *)

Section NatMax.
(*   Set Implicit Parameters. *)

   Lemma max_assoc : @Associative natDecSetoid max.
   Proof. intros x y z; rewrite max_assoc; auto. Defined.

   Lemma max_op_pres_eq : @Preserves natDecSetoid max.
   Proof. intros x y u v p q; rewrite nat_eq in *; rewrite p, q; auto. Defined.

   Definition natMaxSemigroup : Semigroup :=
      Build_Semigroup
         max_assoc (* assoc *)
         max_op_pres_eq (* op_pres_eq *). 

   Lemma max_idemp : forall n, max n n = n.
   Proof. induction n. trivial.
      rewrite <- Max.max_SS, IHn; trivial.
   Qed.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma isIdempotent : IsIdempotent natMaxSemigroup.
   Proof. intros x; simpl; rewrite max_l; auto. Defined.

   Lemma isSelective : IsSelective natMaxSemigroup.
   Proof. intros x y; simpl; destruct (max_dec x y) as [e|e]; rewrite e; auto. Defined.

   Lemma isCommutative : IsCommutative natMaxSemigroup.
   Proof. red; intros; rewrite max_comm. auto. Defined.

   Lemma hasIdentity : HasIdentity natMaxSemigroup.
   Proof. red; exists 0; split; intros; [|rewrite max_comm]; simpl; auto. Defined.

   Lemma hasAnnihilator_comp : HasAnnihilator_comp natMaxSemigroup.
   Proof.
      intros c; exists (S c).
      apply or_introl; simpl; toProp; rewrite max_r; auto.
      rewrite beq_nat_eq; intros; induction c; [discriminate | auto].
   Defined.

   Lemma isLeft_comp : IsLeft_comp natMaxSemigroup.
   Proof. exists 0; exists 1; compute; auto. Defined.

   Lemma isRight_comp : IsRight_comp natMaxSemigroup.
   Proof. exists 1; exists 0; compute; auto. Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp natMaxSemigroup.
   Proof. exists 0; exists 1; exists 0; compute; trivial. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp natMaxSemigroup.
   Proof. exists 0; exists 1; exists 0; compute; trivial. Defined.

   Lemma leftCancelative_comp : LeftCancelative_comp natMaxSemigroup.
   Proof. exists 0; exists 1; exists 1; compute; auto. Defined.

   Lemma rightCancelative_comp : RightCancelative_comp natMaxSemigroup.
   Proof. exists 0; exists 1; exists 1; compute; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp natMaxSemigroup.
   Proof. exists 0; exists 0; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp natMaxSemigroup.
   Proof. exists 0; exists 0; auto. Defined.
   
   Lemma treeGlb : TreeGlb natMaxSemigroup.
   Proof. intros _ _ x y z. simpl.
      destruct (max_dec x y) as [e|e]; rewrite e; auto.
   Qed.

End NatMax.