Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Coq.Setoids.Setoid.
Require Import Coq.Arith.Arith.
Require Import Metarouting.Logic.Logic.

Section MultiSets.
   Set Implicit Arguments.
   
   Variable A : DecSetoid.
   
   Close Scope Semigroup_scope. (* Want to use + on nats, not semigroups *)
   
   Lemma multiset_app_assoc : @Associative  (multisetDecSetoid A) (@app A).
   Proof. intros x y z. rewrite app_ass; auto. Qed.
   
   Lemma multiset_app_pres_eq : @Preserves  (multisetDecSetoid A) (@app A).
   Proof. intros x y u v. dseq_u; simpl.
      repeat rewrite multieq_count.
      intros p q a; repeat rewrite (app_count A); rewrite p, q; auto.
   Qed.
   
   Definition multisetUnionSemigroup :=
      Build_Semigroup
         multiset_app_assoc
         multiset_app_pres_eq.
   
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Ltac multiset_u :=
      simpl; unfold multieq, multisubset; simpl; repeat rewrite refl; simpl.
   
   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite (app_count A) in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.
   
   Lemma isIdempotent_comp : IsIdempotent_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); multiset_u. auto. Defined.
   
   Lemma isSelective_comp : IsSelective_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); multiset_u. auto. Defined.
   
   Lemma isCommutative : IsCommutative multisetUnionSemigroup.
   Proof. intros x y. toCount_u. intros a; toCount. rewrite plus_comm; auto. Qed.
   
   Lemma hasIdentity : HasIdentity multisetUnionSemigroup.
   Proof. exists nil; intros x; toCount_u.
      rewrite <- app_nil_end; auto.
   Defined.
   
   Lemma hasAnnihilator_comp : HasAnnihilator_comp multisetUnionSemigroup.
   Proof. intros x; set (a := choose A); exists (a :: x).
      toProp; toCount_u.
      apply or_introl; intros p; assert (h := p a); toCount.
      simpl in h. rewrite refl in h; simpl in h.
      elim (lt_irrefl (count A a x)).
      rewrite <- h at 2.
      apply le_lt_trans with ((count A a x) + 0); auto.
         rewrite <- plus_n_O; auto.
      apply plus_lt_compat_l.
      apply lt_O_Sn.
   Qed.
   
   Lemma isLeft_comp : IsLeft_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); multiset_u. auto. Defined.

   Lemma isRight_comp : IsRight_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); multiset_u. auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; multiset_u; auto. Defined.
   
   Lemma rightCondensed_comp : RightCondensed_comp multisetUnionSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; multiset_u; auto. Defined.
   
   Lemma leftCancelative : LeftCancelative multisetUnionSemigroup.
   Proof. intros x y z. simpl; toCount_u. intros p a; assert (h := p a); toCount.
      apply (plus_reg_l _ _ _ h); auto.
   Qed.

   Lemma rightCancelative : RightCancelative multisetUnionSemigroup.
   Proof. intros x y z. simpl; toCount_u. intros p a; assert (h := p a); toCount.
      repeat rewrite (plus_comm _ (count A a z)) in h.
      apply (plus_reg_l _ _ _ h); auto.
   Qed.

   Lemma antiLeft_comp : AntiLeft_comp multisetUnionSemigroup.
   Proof. exists nil; exists nil; multiset_u; auto. Defined.
   
   Lemma antiRight_comp : AntiRight_comp multisetUnionSemigroup.
   Proof. exists nil; exists nil; multiset_u; auto. Defined.

   (* always irrelevant *)
   Lemma treeGlb : TreeGlb multisetUnionSemigroup.
   Proof. intros _ idem.
      destruct isIdempotent_comp as [x p].
      assert (h := idem x); toProp; tauto.
   Qed.

End MultiSets.