Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Coq.Setoids.Setoid.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Min.
Require Import Metarouting.Logic.Logic.
Require Import Coq.Sets.Multiset.
Require Import Coq.Sorting.PermutSetoid.
Require Import Coq.Sorting.Permutation.
Require Import Coq.Lists.SetoidList.

Section MultiSets.
   Set Implicit Arguments.
   
   Variable A : Semigroup.

   Definition multiop (x y : multisetDecSetoid A) : multisetDecSetoid A :=
      map (fun w : A*A => let (b,c) := w in b + c) (list_prod x y).

   Ltac multiset_u :=
      simpl; unfold multieq, multisubset; simpl; repeat rewrite refl; simpl.
   
   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite app_count in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.
   
   Lemma list_prod_map_r : forall {X Y Z} (f : Y -> Z) (x : list X) (y : list Y), 
      list_prod x (map f y) = map (fun w : X * Y => let (a,b) := w in (a, f b)) (list_prod x y).
   Proof. intros. generalize y; clear y; induction x; intros y; trivial.
      simpl. rewrite map_app. repeat rewrite map_map; simpl. rewrite IHx; auto.
   Qed.
   
   Lemma list_prod_map_l : forall {X Y Z} (f : X -> Z) (x : list X) (y : list Y), 
      list_prod (map f x) y = map (fun w : X * Y => let (a,b) := w in (f a, b)) (list_prod x y).
   Proof. intros. generalize y; clear y; induction x; intros y; trivial.
      simpl. rewrite map_app. repeat rewrite map_map; simpl. rewrite IHx; auto.
   Qed.
   
   Definition triple_r {X Y Z} (w : X * Y * Z) : X * (Y * Z) :=
      match w with | ((x,y),z) => (x,(y,z)) end.

   Definition triple_l {X Y Z} (w : X * (Y * Z)) : X * Y * Z :=
      match w with | (x,(y,z)) => ((x,y),z) end.
   
   Lemma triple_rl : forall {X Y Z} (w : X * (Y * Z)), triple_r (triple_l w) = w.
   Proof. intros X Y Z [x [y z]]; auto. Qed.

   Lemma triple_lr : forall {X Y Z} (w : X * Y * Z), triple_l (triple_r w) = w.
   Proof. intros X Y Z [[x y] z]; auto. Qed.
   
   Lemma map_id : forall {X Y} (f : X -> Y) (g : Y -> X),
       (forall y, f (g y) = y) ->
       forall l, map f (map g l) = l.
   Proof. intros X Y f g p l. induction l. trivial.
      simpl. rewrite p, IHl; auto.
   Qed.
   
   Lemma count_permutation : forall {D : DecSetoid} {x y}, Permutation x y -> forall a, count D a x = count D a y.
   Proof. intros D x y p a.
      induction p. trivial.
      simpl. destruct (a == x); auto.
      simpl. destruct (a == x); destruct (a == y); auto.
      rewrite IHp1, IHp2; auto.
   Qed.
   
   Lemma list_prod_nil : forall {X Y} (x : list X), list_prod x (@nil Y) = nil.
   Proof. intros X Y x; induction x; auto. Qed.
   
   Lemma iso_permutation : forall {X Y} (f : X -> Y) (g : Y -> X) (x : list X) (y : list Y),
      (forall w, f (g w) = w) ->
      (forall w, g (f w) = w) ->
      (Permutation (map f x) y <-> Permutation x (map g y)).
   Proof.
      intros X Y f g x y p q. split; intros h.
      assert (p1 := Permutation_map g h).
      rewrite map_id in p1; auto.
      assert (p1 := Permutation_map f h).
      rewrite map_id in p1; auto.
   Qed.
   
   Lemma list_prod_app_l : forall {X Z} (x y : list X) (z : list Z), Permutation (list_prod (x ++ y) z) (list_prod x z ++ list_prod y z).
   Proof. intros.
      generalize y z; clear y z.
      induction x. intros y z; simpl. apply Permutation_refl.
      intros y z; simpl.
      rewrite app_ass.
      apply Permutation_app.
      apply Permutation_refl.
      apply IHx.
   Qed.
   
   Lemma list_prod_app_r : forall {X Z} (x : list X) (y z : list Z), Permutation (list_prod x (y ++ z)) (list_prod x y ++ list_prod x z).
   Proof. intros X Z x.
      induction x. intros y z;  simpl. apply perm_nil.
      intros y z. simpl.
      rewrite app_ass. rewrite map_app. rewrite app_ass.
      apply Permutation_app.
      apply Permutation_refl.
      apply Permutation_trans with ((map (fun y0 : Z => (a, y0)) z) ++ (list_prod x y ++ list_prod x z)).
      apply Permutation_app.
      apply Permutation_refl.
      apply IHx.
      repeat rewrite <- app_ass.
      apply Permutation_app.
      apply Permutation_app_swap.
      apply Permutation_refl.
   Qed.

   Lemma triple_permutation : forall {X Y Z} (x : list X) (y : list Y) (z : list Z),
      Permutation (map triple_r (list_prod (list_prod x y) z)) (list_prod x (list_prod y z)).
   Proof. intros X Y Z x. induction x as [|a x].
      intros y z; simpl. apply perm_nil.
      intros y z; simpl.
      rewrite (iso_permutation _ _ _ _ triple_rl triple_lr).
      eapply Permutation_trans; [apply list_prod_app_l|].
      rewrite map_app.
      apply Permutation_app; [|rewrite <- (iso_permutation _ _ _ _ triple_rl triple_lr); auto].
      rewrite list_prod_map_l.
      rewrite map_map; simpl.
      apply Permutation_refl.
   Qed.
   
   Lemma count_map_ext : forall {D : DecSetoid} {T} a x (f g : T -> D), 
      (forall w, f w == g w) ->
      count D a (map f x) = count D a (map g x).
   Proof. intros D T a x f g p. induction x. trivial.
      simpl.
      assert ((a == f a0)%bool = (a == g a0)%bool) as q.
         rewrite bool_eq; dseq_f. split; rewrite p; auto.
      rewrite q.
      destruct (a == g a0); auto.
   Qed.

   Lemma multiop_assoc : Associative multiop.
   Proof. intros x y z. toCount_u. intros a; toCount.
      unfold multiop.
      rewrite list_prod_map_r. rewrite map_map.
      rewrite list_prod_map_l. rewrite map_map.
      rewrite <- (map_id triple_l triple_r triple_lr (list_prod (list_prod x y) z)).
      rewrite map_map. unfold triple_l; simpl.
      match goal with
      | |- count _ _ (map ?f ?X) = _ => assert (h := Permutation_map f (triple_permutation x y z))
      end.
      rewrite (count_permutation h).
      match goal with
      | |- count _ _ (map ?f _) = count _ _ (map ?g _) => assert (forall w, f w == g w) as q
      end.
      clear; intros [w1 [w2 w3]]; simpl; auto.
      rewrite (assoc A w1 w2 w3); auto.
      rewrite (count_map_ext _ _ _ _ q); auto.
   Qed.
   
   Lemma dseq_dec : forall (D : DecSetoid) (x y : D), {x == y} + {~(x == y)}.
   Proof. intros D x y. dseq_u; destruct (x == y). auto.
      apply right. intros h; discriminate h.
   Defined.
   
   Notation "'permut' B" := (@permutation _ _ (dseq_dec B)) (at level 0, no associativity).
   
   Lemma list_contents_inject : forall {D : DecSetoid} (x : multisetDecSetoid D), 
      meq (list_contents _ (dseq_dec D) x) (minject x).
   Proof. intros D x; simpl.
      unfold meq; simpl. intros a.
      induction x. trivial.
      simpl. rewrite IHx.
      destruct dseq_dec.
      assert (a == a0) as q; [rewrite d; auto| rewrite q; auto].
      assert (a == a0 = false) as q; [|rewrite q; auto].
         bool_p; intros h; apply n; dseq_f; rewrite h; auto.
   Qed.
   
   Lemma permutation_multieq : forall {D : DecSetoid} (x y : multisetDecSetoid D), permut D x y <-> x == y.
   Proof. intros D x y. unfold permutation; simpl.
      rewrite <- multieq_inject. split; intros h.
      apply meq_trans with (list_contents _ (dseq_dec D) y); [|apply list_contents_inject].
      apply meq_trans with (list_contents _ (dseq_dec D) x); auto.
      apply meq_sym; apply list_contents_inject.
      apply meq_trans with (minject x); [apply list_contents_inject|].
      apply meq_trans with (minject y); auto.
      apply meq_sym; apply list_contents_inject.
   Qed.
   
   Ltac toPermut :=
      repeat rewrite <- permutation_multieq.
      
   Lemma Permutation_permut : forall (D : DecSetoid) x y, Permutation x y -> permut (D) x y.
   Proof. intros Ds x y p. rewrite permutation_multieq. toCount_u. apply count_permutation. auto. Qed.
   
   Lemma count_map_pres_eq :  forall (D T : DecSetoid) a (x y : multisetDecSetoid T) (f g : T -> D), 
      (forall w1 w2, w1 == w2 -> f w1 == f w2) ->
      (forall w, f w == g w) ->
      x == y ->
      count D a (map f x) = count D a (map g y).
   Proof. intros D T a x y f g peq p q.
      apply trans_eq with (count D a (map f y)); [| apply count_map_ext; auto].
      clear p g.
      generalize a.
      rewrite <- multieq_count.
      rewrite <- permutation_multieq in q.
      assert (h := permut_map (refl T) (sym T) (trans T) (@dseq D) (dseq_dec D) (trans D) f peq q).
      rewrite permutation_multieq in h; auto.
   Qed.
   
   Lemma list_prod_pres_permut : forall x y u v,
      permut (A) x u -> 
      permut (A) y v -> 
      permut (prodDecSetoid A A) (list_prod x y) (list_prod u v).
   Proof. intros x y u v p q.
      generalize u p; clear p u;
      generalize v q; clear q v.
      generalize y; clear y.
      induction x. simpl. intros y v q u p.
      rewrite (permut_nil (refl A) (sym A) (permut_sym p)). simpl. apply permut_refl.
      intros y v q u p. simpl in *.
      assert (h := permut_cons_InA (refl A) (sym A) p).
      assert (h1 := InA_split h). simpl in h1.
      destruct h1 as [u1 [a' [u2 [p1 p2]]]].
      rewrite p2.
      assert (h2 := Permutation_permut (prodDecSetoid A A) (list_prod_app_l u1 (a' :: u2) v)).
      assert (h3 := permut_sym h2).
      eapply permut_tran; [|apply h3]. simpl.
      apply permut_tran with (map (fun y0 => (a', y0)) v ++ (list_prod u1 v ++ list_prod u2 v)).
      apply permut_app.
         rewrite (@permutation_multieq (prodDecSetoid A A)). toCount_u. 
         intros b. apply count_map_pres_eq.
            intros w1 w2 w3; dseq_u; simpl; toProp; dseq_f; auto.
         intros w; dseq_u; simpl; toProp; dseq_f; auto.
         toPermut; auto.
         clear h2 h3.
         assert (permut (A) (a :: x) (a' :: x)) as h2.
            rewrite permutation_multieq. 
            toCount_u; intros b. simpl.
            assert ((b == a) = (b == a')) as p3; [|rewrite p3; simpl; auto].
               rewrite bool_eq; split; dseq_f; rewrite p1; intros h1; auto.
            assert (permut (A) (a' :: x) (u1 ++ (a' :: u2))) as h3.
               apply (permut_tran (permut_sym h2)); auto.
               rewrite p2 in p; auto.
            assert (permut (A) x (u1 ++ u2)) as h4.
               apply (permut_remove_hd u1 u2 h3).
            assert (h5 := IHx y v q (u1 ++ u2) h4).
            assert (h6 := Permutation_permut (prodDecSetoid A A) (list_prod_app_l u1 u2 v)).
            apply (permut_tran h5 h6).
      repeat rewrite <- app_ass.
      apply permut_app.
      apply permut_sym_app.
      apply permut_refl.
   Qed.
      
   Lemma multiop_pres_eq : Preserves multiop.
   Proof. intros x y u v. toPermut.
      intros p q.
      unfold multiop.
      apply permut_map with (@dseq (prodDecSetoid A A)) (dseq_dec (prodDecSetoid A A)).
         intros; auto.
         intros a b e; rewrite e; auto.
         intros a b c e1 e2; rewrite e1, e2; auto.
         intros a b c e1 e2; rewrite e1, e2; auto.
         intros [x1 x2] [y1 y2]; dseq_u; simpl; toProp; dseq_f; intros [p1 p2]; auto.
            rewrite p1, p2; auto.
            apply list_prod_pres_permut; auto.
   Qed.
   
   Lemma permut_cons : forall (D : DecSetoid) (a a' : D) x y, 
      a == a' -> 
      permut (D) x y ->
      permut (D) (a :: x) (a' :: y).
   Proof. intros D a a' x y.
      repeat rewrite permutation_multieq.
      toCount_u. intros e e' b; simpl.
      assert ((b == a) = (b == a')) as q; [|rewrite q; simpl; auto].
         rewrite bool_eq; split; dseq_f; rewrite e; auto.
      rewrite (e' b); auto.
   Qed.
   
   Definition multiOpSemigroup : Semigroup :=
      Build_Semigroup
         multiop_assoc
         multiop_pres_eq.
      
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma permutation_multieq2 : forall (D : DecSetoid) (x y : list D), permut (D) x y <-> multieq D x y.
   Proof. intros D x y. apply (@permutation_multieq D). Qed.

   Ltac toPermut2_u :=
      dseq_u; simpl in *;
      repeat rewrite <- permutation_multieq2 in *.
   
   Lemma isIdempotent_comp : IsIdempotent_comp multiOpSemigroup.
   Proof. set (a := choose A); exists (a :: a :: nil).
      simpl. multiset_u.
      copy_destruct (a + a == a); rewrite ew; simpl; auto.
   Defined.
   
   Lemma isSelective_comp : IsSelective_comp multiOpSemigroup.
   Proof. destruct (isIdempotent_comp) as [x p].
      exists x; exists x. auto.
   Defined.
   
   Lemma isCommutative : IsCommutative A -> IsCommutative multiOpSemigroup.
   Proof. intros comm x y. dseq_u; simpl; toPermut2_u.
      unfold multiop.
      generalize y; clear y; induction x.
      intros y; simpl. rewrite list_prod_nil. apply permut_refl.
      intros y; simpl.
      rewrite map_app.
      assert (h := Permutation_permut (prodDecSetoid A A) (list_prod_app_r y (a :: nil) x)); simpl in h.
      apply permut_sym.
      apply (permut_tran) with (map (fun w : A*A => let (b,c) := w in b + c) (list_prod y (a :: nil) ++ list_prod y x)).
         apply (@permut_map _ _ (dseq_dec (prodDecSetoid A A))).
            apply (refl (prodDecSetoid A A)).
            apply (sym (prodDecSetoid A A)).
            apply (trans (prodDecSetoid A A)).
            apply (trans A).
            intros [x1 x2] [y1 y2]; dseq_u; simpl; toProp; dseq_f; intros [p1 p2]; rewrite p1, p2; auto.
         apply h.
      clear h.
      repeat rewrite map_app.
      apply permut_app; [|apply permut_sym; auto].
      clear -comm. rewrite map_map.
      induction y. simpl. apply permut_refl.
      simpl.
      apply permut_cons. apply comm.
      apply IHy.
   Qed.
   
   Lemma isCommutative_comp : IsCommutative_comp A -> IsCommutative_comp multiOpSemigroup.
   Proof. intros [a [b p]].
      exists (a :: nil); exists (b :: nil); multiset_u; simpl.
      assert (a + b == b + a = false) as q.
         bool_p; toProp; auto.
      assert (b + a == a + b = false) as q'.
         bool_p; intros h; apply q; dseq_f; rewrite h; auto.
      rewrite q, q'; simpl; auto.
   Defined.
   
   Lemma hasIdentity : HasIdentity A -> HasIdentity multiOpSemigroup.
   Proof. intros [i hid]. exists (i :: nil).
      intros x; split.
      induction x. trivial.
      toPermut2_u. unfold multiop in *.
      simpl in *. repeat rewrite <- app_nil_end in *.
      apply permut_cons.
         destruct (hid a); auto.
      auto.

      induction x. trivial.
      toPermut2_u. unfold multiop in *.
      simpl in *.
      apply permut_cons.
         destruct (hid a); auto.
      auto.
   Defined.

   Lemma hasIdentity_comp : HasIdentity_comp A -> HasIdentity_comp multiOpSemigroup.
   Proof. intros hid.
      intros i.

      

End MultiSets.