Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.Semigroups.Unit.

Section Left.

   Variable A : DecSetoid.

   Definition left_op (x y : A) : A := x.

   Lemma left_op_assoc : Associative left_op.
   Proof. intros x y z; simpl; auto. Qed.
   
   Lemma left_op_pres_eq : Preserves left_op.
   Proof. intros x y u v p q. apply p. Qed.
   
   Definition leftSemigroup : Semigroup :=
      Build_Semigroup
         left_op_assoc (* assoc *)
         left_op_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)	
   
   Lemma isIdempotent : IsIdempotent leftSemigroup.
   Proof. intros x; auto. Defined.
   
   Lemma isSelective : IsSelective leftSemigroup.
   Proof. intros x y; auto. Defined.
   
   Lemma isCommutative : IsSingleton A -> IsCommutative leftSemigroup.
   Proof. intros sg; apply (Iso_IsCommutative (SmgIso_sym (unitSmgIso leftSemigroup sg))); apply Unit.isCommutative.
   Defined.
   
   Lemma isCommutative_comp : IsSingleton_comp A -> IsCommutative_comp leftSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb]; 
      exists b; exists (choose A); apply pb.
   Defined.
   
   Lemma hasIdentity : IsSingleton A -> HasIdentity leftSemigroup.
   Proof. intros [a sg]; exists a; intros x; simpl; unfold left_op.
      rewrite (sg x); auto.
   Defined.
   
   Lemma hasIdentity_comp : IsSingleton_comp A -> HasIdentity_comp leftSemigroup.
   Proof. intros sg x; destruct (sg x) as [b pb];
      exists b; simpl. unfold left_op; toProp; apply or_introl; intros h; elim pb; dseq_f; 
      rewrite h; auto.
   Defined.
   
   Lemma hasAnnihilator : IsSingleton A -> HasAnnihilator leftSemigroup.
   Proof. intros [a sg]; exists a; intros x; simpl; unfold left_op.
      rewrite (sg x); auto.
   Defined.
   
   Lemma hasAnnihilator_comp : IsSingleton_comp A -> HasAnnihilator_comp leftSemigroup.
   Proof. intros sg x; destruct (sg x) as [b pb];
      exists b; simpl. unfold left_op; toProp; apply or_intror; intros h; elim pb; dseq_f; 
      rewrite h; auto.
   Defined.
   
   Lemma isLeft : IsLeft leftSemigroup.
   Proof. intros x y; auto. Defined.
   
   Lemma isRight : IsSingleton A -> IsRight leftSemigroup.
   Proof. intros [a sg] x y; simpl; unfold left_op; rewrite (sg x), (sg y); auto. Defined.
   
   Lemma isRight_comp : IsSingleton_comp A -> IsRight_comp leftSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb]; 
      exists b; exists (choose A); simpl; unfold left_op; auto.
   Defined.
   
   Lemma leftCondensed : LeftCondensed leftSemigroup.
   Proof. intros x y z; auto. Defined.
   
   Lemma rightCondensed : IsSingleton A -> RightCondensed leftSemigroup.
   Proof. intros [a sg] x y z; simpl; unfold left_op; rewrite (sg y), (sg z); auto. Defined.
   
   Lemma rightCondensed_comp : IsSingleton_comp A -> RightCondensed_comp leftSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb];
      exists b; exists b; exists (choose A); simpl; unfold left_op; auto.
   Defined.
   
   Lemma leftCancelative : IsSingleton A -> LeftCancelative leftSemigroup.
   Proof. intros [a sg] x y z _; simpl. rewrite (sg x), (sg y); auto. Defined.
   
   Lemma leftCancelative_comp : IsSingleton_comp A -> LeftCancelative_comp leftSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb];
      exists b; exists (choose A); exists b; simpl; unfold left_op; auto.
   Defined.
   
   Lemma rightCancelative : RightCancelative leftSemigroup.
   Proof. intros x y z h. apply h. Defined.

   Lemma antiRight_comp : AntiRight_comp leftSemigroup.
   Proof. exists (choose A); exists (choose A); auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp leftSemigroup.
   Proof. exists (choose A); exists (choose A); auto. Defined.
   
   Lemma treeGlb : TreeGlb leftSemigroup.
   Proof. intros comm idem x y z; simpl. unfold left_op; simpl. auto. Qed.

End Left.