Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

(************************************************************************)
(*                finite sets with union as operation                   *)
(************************************************************************)

Section FSetsUnion.

   Variable A : DecSetoid.

   Lemma union_assoc : @Associative (fsetDecSetoid A) (union A).
   Proof. intros x y z; toSet_u. rewrite orb_assoc; auto. Defined.

   Lemma union_pres_eq : @Preserves (fsetDecSetoid A) (union A).
   Proof. intros x y u v p q; toSet_u; rewrite p, q; auto. Defined.

   Definition fsetsUnionSemigroup : Semigroup :=
      Build_Semigroup
         union_assoc (* assoc *)
         union_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma isIdempotent : IsIdempotent fsetsUnionSemigroup.
   Proof. intros x; toSet_u; destruct (mem a x); auto. Defined.
      
   Lemma isSelective : IsSingleton A -> IsSelective fsetsUnionSemigroup.
   Proof.
      intros [a sa] [|x xs] [|y ys].
      apply or_introl; auto.
      apply or_intror; toSet_u; auto.
      apply or_introl; toSet_u; simpl; rewrite orb_false_r; auto.
      apply or_introl; unfold dseq; toSet; simpl; rewrite (sa x), (sa a0); auto.
   Defined.
   
   Lemma isSelective_comp : IsSingleton_comp A -> IsSelective_comp fsetsUnionSemigroup.
   Proof. intros sa; destruct (sa (choose A)) as [b pb]; 
      exists (choose A :: nil); exists (b :: nil).
      toProp; toSet_u; split; intros h; elim pb.
      assert (h' := h b); toSet; simpl in h'; rewrite refl in h'; simpl in h';
      rewrite orb_true_r, orb_false_r in h'; rewrite <- h'; auto.
      assert (h' := h (choose A)); toSet; simpl in h'; rewrite refl in h'; simpl in h';
      rewrite orb_false_r in h'; apply sym; rewrite <- h'; auto.
   Defined.
   
   Lemma isCommutative : IsCommutative fsetsUnionSemigroup.
   Proof. intros x y; toSet_u; rewrite orb_comm; auto. Defined.
   
   Lemma hasIdentity : HasIdentity fsetsUnionSemigroup.
   Proof. exists (nil : list A); intros x; split; toSet_u; simpl; rewrite ?orb_false_r; auto. Defined.
   
   Lemma hasAnnihilator : Finite A -> HasAnnihilator fsetsUnionSemigroup.
   Proof. intros [l fl]. exists l.
      assert (forall a, mem a l) as h.
         intros a; assert (p := fl a); induction l;
         [ discriminate p
         | simpl in *; copy_destruct (a == a0); auto ].
      intros x; split; unfold dseq; toSet; simpl; rewrite h, ?orb_true_r; auto.
   Defined.
   
   Lemma hasAnnihilator_comp : Finite_comp A -> HasAnnihilator_comp fsetsUnionSemigroup.
   Proof. intros fl x; destruct (fl x) as [y py].
      assert (mem y x = false) as h.
         induction x;
         [ auto
         | simpl in *; copy_destruct (y == a); rewrite ew in *; auto ].
      exists (y :: nil); apply or_introl.
      toProp; intros p; toSet. assert (p' := p y); toSet; simpl in p'.
      rewrite refl, h in p'; simpl in p'; discriminate p'.
   Defined.

   Lemma isLeft_comp : IsLeft_comp fsetsUnionSemigroup.
   Proof. exists nil; exists ((choose A) :: nil); toSet_u; auto. Defined.
   
   Lemma isRight_comp : IsRight_comp fsetsUnionSemigroup.
   Proof. exists ((choose A) :: nil); exists nil; toSet_u; auto. Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp fsetsUnionSemigroup.
   Proof. exists nil; exists nil; exists ((choose A) :: nil); toSet_u; auto. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp fsetsUnionSemigroup.
   Proof. exists nil; exists nil; exists ((choose A) :: nil); toSet_u; auto. Defined.

   Lemma leftCancelative_comp : LeftCancelative_comp fsetsUnionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists (choose A :: nil);
      dseq_u; simpl. unfold eq_fset, subset, union; simpl.
      repeat progress (rewrite refl; simpl; auto).
   Defined.

   Lemma rightCancelative_comp : RightCancelative_comp fsetsUnionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists (choose A :: nil);
      dseq_u; simpl. unfold eq_fset, subset, union; simpl.
      repeat progress (rewrite refl; simpl; auto).
   Defined.

   Lemma antiRight_comp : AntiRight_comp fsetsUnionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp fsetsUnionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma treeGlb_comp : IsSingleton_comp A -> TreeGlb_comp fsetsUnionSemigroup.
   Proof. intros sg comm idem. set(a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil.
      simpl. unfold eq_fset, subset, union; simpl.
      assert (a == b = false) as e.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h. auto.
      repeat (rewrite e; simpl).
      repeat progress (rewrite refl; simpl; auto).
      negb_p; simpl; toProp; bool_p; tauto.
   Defined.
   
   Lemma treeGlb : IsSingleton A -> TreeGlb fsetsUnionSemigroup.
   Proof. intros [a sg] comm idem [|w1 x] [|w2 y] [|w3 z]; unfold dseq; toSet; simpl.
      apply or_introl. auto.
      apply or_introl; intros t; simpl. auto.
      apply or_intror; intros t; toSet_u. simpl. auto.
      apply or_intror; intros t; toSet_u. simpl. auto.
      apply or_introl; intros t; toSet_u. simpl. repeat (rewrite orb_false_r); auto.
      apply or_introl; intros t; toSet_u. simpl. repeat (rewrite orb_false_r); auto.
      apply or_introl; intros t; toSet. simpl. repeat (rewrite orb_false_r); auto.
      assert (t == w1) as e.
         dseq_f; rewrite (sg t), (sg w1); auto.
      rewrite e. auto.
      apply or_introl; intros t; toSet. simpl. repeat (rewrite orb_false_r); auto.
      assert (t == w1) as e.
         dseq_f; rewrite (sg t), (sg w1); auto.
      rewrite e. auto.
   Qed.      

End FSetsUnion.