Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

(************************************************************************)
(*             finite sets with intersection as operation               *)
(************************************************************************)

Section FSetsIntersection.

   Variable A : DecSetoid.

   Lemma fset_inter_assoc : @Associative (fsetDecSetoid A) (intersect A).
   Proof. intros x y z; toSet_u; rewrite andb_assoc; auto. Defined.

   Lemma fset_inter_pres_eq : @Preserves (fsetDecSetoid A) (intersect A).
   Proof. intros x y u v p q; toSet_u; rewrite p, q; auto. Defined.
   
   Definition fsetsIntersectionSemigroup : Semigroup :=
      Build_Semigroup
         fset_inter_assoc (* assoc *)
         fset_inter_pres_eq (* op_pres_eq *).


   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isIdempotent : IsIdempotent fsetsIntersectionSemigroup.
   Proof. intros x; toSet_u; destruct (mem a x); auto. Defined.
   
   Lemma isSelective : IsSingleton A -> IsSelective fsetsIntersectionSemigroup.
   Proof. intros [a sa] [|x xs] [|y ys]; simpl.
      apply or_introl; auto.
      apply or_introl; auto.
      apply or_intror; unfold dseq; toSet; simpl; rewrite andb_false_r; auto.
      apply or_introl; unfold dseq; toSet; simpl.
      assert (x == y) as h. rewrite (sa x), (sa y); auto.
      rewrite h. simpl. rewrite (sa x), (sa a0); auto.
   Defined.
   
   Lemma isSelective_comp : IsSingleton_comp A -> IsSelective_comp fsetsIntersectionSemigroup.
   Proof. intros sa; destruct (sa (choose A)) as [b pb].
      exists (choose A :: nil); exists (b :: nil). simpl.
      copy_destruct (choose A == b); rewrite ew; simpl;
      [ dseq_f; rewrite ew, refl in pb; discriminate pb
      | auto ].
   Defined.
   
   Lemma isCommutative : IsCommutative fsetsIntersectionSemigroup.
   Proof. intros x y; toSet_u; rewrite andb_comm; auto. Defined.

   Lemma hasIdentity : Finite A -> HasIdentity fsetsIntersectionSemigroup.
   Proof. intros [l fl]. exists l.
      assert (forall a, mem a l) as h.
         intros a; assert (p := fl a); induction l;
         [ discriminate p
         | simpl in *; copy_destruct (a == a0); auto ].
      intros x; split; toSet_u; rewrite h, ?andb_true_r; auto.
   Defined.
   
   Lemma hasIdentity_comp : Finite_comp A -> HasIdentity_comp fsetsIntersectionSemigroup.
   Proof. intros fl x.
      destruct (fl x) as [y py].
      assert (mem y x = false) as h.
         induction x;
         [ auto
         | simpl in *; copy_destruct (y == a); rewrite ew in *; auto ].
      exists (y :: nil); apply or_intror; toProp; intros p; toSet.
      rewrite h in p. assert (p' := p y); simpl in p'; rewrite refl in p'; discriminate p'.
   Defined.
   
   Lemma hasAnnihilator : HasAnnihilator fsetsIntersectionSemigroup.
   Proof. exists (nil : list A); intros x; split; toSet_u; simpl; rewrite ?andb_false_r; auto. Defined.
   
   Lemma isLeft_comp : IsLeft_comp fsetsIntersectionSemigroup.
   Proof. exists ((choose A) :: nil); exists nil; toSet_u; auto. Defined.
   
   Lemma isRight_comp : IsRight_comp fsetsIntersectionSemigroup.
   Proof. exists nil; exists ((choose A) :: nil); toSet_u; auto. Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp fsetsIntersectionSemigroup.
   Proof. exists ((choose A) :: nil); exists nil; exists ((choose A) :: nil).
      toProp; intros h; toSet_u; simpl in *. 
      assert (p := h (choose A)); rewrite refl in p; simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma rightCondensed_comp : RightCondensed_comp fsetsIntersectionSemigroup.
   Proof. exists ((choose A) :: nil); exists nil; exists ((choose A) :: nil).
      toProp; intros h; toSet_u; simpl in *. 
      assert (p := h (choose A)); rewrite refl in p; simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma leftCancelative_comp : LeftCancelative_comp fsetsIntersectionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists nil; intuition. Defined.

   Lemma rightCancelative_comp : RightCancelative_comp fsetsIntersectionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists nil; intuition. Defined.

   Lemma antiRight_comp : AntiRight_comp fsetsIntersectionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp fsetsIntersectionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.



End FSetsIntersection.