Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Bool.
Require Import Coq.Bool.Bool.

Section BoolOr.

   Lemma bool_or_assoc : @Associative boolDecSetoid orb.
   Proof. intros x y z; rewrite orb_assoc; auto. Defined.
   
   Lemma bool_or_pres_eq : @Preserves boolDecSetoid orb.
   Proof. intros [|] [|] [|] [|]; auto. Defined.
  
   Definition boolOrSemigroup : Semigroup :=
      Build_Semigroup
         bool_or_assoc (* assoc *)
         bool_or_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isIdempotent : IsIdempotent boolOrSemigroup.
   Proof. intros [|]; auto. Defined.
   
   Lemma isSelective : IsSelective boolOrSemigroup.
   Proof. intros [|] [|]; auto. Defined.
   
   Lemma isCommutative : IsCommutative boolOrSemigroup.
   Proof. intros [|] [|]; auto. Defined.
   
   Lemma hasIdentity : HasIdentity boolOrSemigroup.
   Proof. exists false; intros [|]; auto. Defined.

   Lemma hasAnnihilator : HasAnnihilator boolOrSemigroup.
   Proof. exists true; intros [|]; auto. Defined.
   
   Lemma isLeft_comp : IsLeft_comp boolOrSemigroup.
   Proof. exists false; exists true; auto. Defined.

   Lemma isRight_comp : IsRight_comp boolOrSemigroup.
   Proof. exists true; exists false; auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp boolOrSemigroup.
   Proof. exists false; exists true; exists false; auto. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp boolOrSemigroup.
   Proof. exists false; exists true; exists false; auto. Defined.
   
   Lemma leftCancelative_comp : LeftCancelative_comp boolOrSemigroup.
   Proof. exists false; exists true; exists true; auto. Defined.

   Lemma rightCancelative_comp : RightCancelative_comp boolOrSemigroup.
   Proof. exists false; exists true; exists true; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp boolOrSemigroup.
   Proof. exists true; exists true; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp boolOrSemigroup.
   Proof. exists true; exists true; auto. Defined.

   Lemma treeGlb : TreeGlb boolOrSemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

End BoolOr.
