Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Constructions.Transforms.Union.
Require Import Metarouting.Signatures.IdArrow.


Section Union.

   (* Similarly to Constructors.Tranforms.Union.unionTransform
    * instead of taking whole structures as arguments we takes their
    * parts.
    *    (S, F, app_f, app_pres_eq_f)
    *    (S, G, app_g, app_pres_eq_g)
    *)
   Variable S : Semigroup.
   Variable F G : DecSetoid.
   Variable app_f : F -> S -> S.
   Variable app_g : G -> S -> S.
   Variable app_pres_eq_f : AppPreserve app_f.
   Variable app_pres_eq_g : AppPreserve app_g.

   Definition unionSemigroupTransform_SgEq : SemigroupTransform :=
      glueSTf_DsEq S (unionTransform_DsEq S F G app_f app_g app_pres_eq_f app_pres_eq_g) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope SemigroupTransform_scope.

   Local Notation A := (Build_SemigroupTransform (Semigroup.assoc S) (Semigroup.op_pres_eq S) app_pres_eq_f).
   Local Notation B := (Build_SemigroupTransform (Semigroup.assoc S) (Semigroup.op_pres_eq S) app_pres_eq_g).
   
   Lemma distributive : Distributive A * Distributive B -> Distributive unionSemigroupTransform_SgEq.
   Proof. intros [da db] x y [f|f]; simpl. apply da. apply db. Defined.
   
   Lemma distributive_comp : Distributive_comp A + Distributive_comp B -> Distributive_comp unionSemigroupTransform_SgEq.
   Proof. intros [[x [y [f da]]] | [x [y [f db]]]].
      exists x; exists y; exists (inl _ f); auto.
      exists x; exists y; exists (inr _ f); auto.
   Defined.
   
   (************************************************************)
   (*           Commutative + Idempotent properties            *)
   (************************************************************)
   
   Lemma isCommutative_back_a : IsCommutative unionSemigroupTransform_SgEq -> IsCommutative A.
   Proof. auto. Defined.

   Lemma isCommutative_back_b : IsCommutative unionSemigroupTransform_SgEq -> IsCommutative B.
   Proof. auto. Defined.

   Lemma isIdempotent_back_a : IsIdempotent unionSemigroupTransform_SgEq -> IsIdempotent A.
   Proof. auto. Defined.

   Lemma isIdempotent_back_b : IsIdempotent unionSemigroupTransform_SgEq -> IsIdempotent B.
   Proof. auto. Defined.
   
   Lemma inflationary : Inflationary A * Inflationary B -> Inflationary unionSemigroupTransform_SgEq.
   Proof. intros [ia ib] comm idem x [f|f]; simpl. 
      apply (ia (isCommutative_back_a comm) (isIdempotent_back_a idem)).
      apply (ib (isCommutative_back_b comm) (isIdempotent_back_b idem)).
   Defined.

   Lemma inflationary_comp : Inflationary_comp A + Inflationary_comp B -> Inflationary_comp unionSemigroupTransform_SgEq.
   Proof. intros [ia | ib] comm idem.
      destruct (ia (isCommutative_back_a comm) (isIdempotent_back_a idem)) as [x [f ia']];
      exists x; exists (inl _ f); simpl; apply ia'.
      destruct (ib (isCommutative_back_b comm) (isIdempotent_back_b idem)) as [x [f ib']];
      exists x; exists (inr _ f); simpl; apply ib'.
   Defined.

   Lemma deflationary : Deflationary A * Deflationary B -> Deflationary unionSemigroupTransform_SgEq.
   Proof. intros [ia ib] comm idem x [f|f]; simpl. 
      apply (ia (isCommutative_back_a comm) (isIdempotent_back_a idem)).
      apply (ib (isCommutative_back_b comm) (isIdempotent_back_b idem)).
   Defined.

   Lemma deflationary_comp : Deflationary_comp A + Deflationary_comp B -> Deflationary_comp unionSemigroupTransform_SgEq.
   Proof. intros [ia | ib] comm idem.
      destruct (ia (isCommutative_back_a comm) (isIdempotent_back_a idem)) as [x [f ia']];
      exists x; exists (inl _ f); simpl; apply ia'.
      destruct (ib (isCommutative_back_b comm) (isIdempotent_back_b idem)) as [x [f ib']];
      exists x; exists (inr _ f); simpl; apply ib'.
   Defined.

   Lemma strictInflationary : StrictInflationary A * StrictInflationary B -> StrictInflationary unionSemigroupTransform_SgEq.
   Proof. intros [sia sib] comm idem x [f|f]; simpl. 
      apply (sia (isCommutative_back_a comm) (isIdempotent_back_a idem)).
      apply (sib (isCommutative_back_b comm) (isIdempotent_back_b idem)).
   Defined.

   Lemma strictInflationary_comp : StrictInflationary_comp A + StrictInflationary_comp B -> StrictInflationary_comp unionSemigroupTransform_SgEq.
   Proof. intros [sia | sib] comm idem; simpl.
      destruct (sia (isCommutative_back_a comm) (isIdempotent_back_a idem)) as [x [f sia']];
      exists x; exists (inl _ f); simpl; apply sia'.
      destruct (sib (isCommutative_back_b comm) (isIdempotent_back_b idem)) as [x [f sib']];
      exists x; exists (inr _ f); simpl; apply sib'.
   Defined.

   Lemma strictDeflationary : StrictDeflationary A * StrictDeflationary B -> StrictDeflationary unionSemigroupTransform_SgEq.
   Proof. intros [sia sib] comm idem x [f|f]; simpl. 
      apply (sia (isCommutative_back_a comm) (isIdempotent_back_a idem)).
      apply (sib (isCommutative_back_b comm) (isIdempotent_back_b idem)).
   Defined.

   Lemma strictDeflationary_comp : StrictDeflationary_comp A + StrictDeflationary_comp B -> StrictDeflationary_comp unionSemigroupTransform_SgEq.
   Proof. intros [sia | sib] comm idem; simpl.
      destruct (sia (isCommutative_back_a comm) (isIdempotent_back_a idem)) as [x [f sia']];
      exists x; exists (inl _ f); simpl; apply sia'.
      destruct (sib (isCommutative_back_b comm) (isIdempotent_back_b idem)) as [x [f sib']];
      exists x; exists (inr _ f); simpl; apply sib'.
   Defined.
   
   (************************************************************)
   (*                   Identity properties                    *)
   (************************************************************)
   
   Lemma hasId_back_a : HasIdentity unionSemigroupTransform_SgEq -> HasIdentity A.
   Proof. auto. Defined.
   
   Lemma hasId_back_b : HasIdentity unionSemigroupTransform_SgEq -> HasIdentity B.
   Proof. auto. Defined.
   
   Lemma id_iso : forall (p : HasIdentity unionSemigroupTransform_SgEq), 
      (projT1 p) == (projT1 (hasId_back_b p)).
   Proof. intros [id p]. unfold hasId_back_b; simpl; auto. Defined.
   
   Lemma strict : Strict A * Strict B -> Strict unionSemigroupTransform_SgEq.
   Proof. intros [sa sb] hasId [f|f]; simpl. apply sa. apply sb. Defined.

   Lemma strict_comp : Strict_comp A + Strict_comp B -> Strict_comp unionSemigroupTransform_SgEq.
   Proof. intros [sa | sb] hasId.
      destruct (sa (hasId_back_a hasId)) as [f p]. exists (inl _ f); auto.
      destruct (sb (hasId_back_b hasId)) as [f p]. exists (inr _ f); auto.
   Defined.

End Union.

Section UnionIso.

   Variable A B : SemigroupTransform.
   Variable f : IdSmgIso A B.
   
   Definition unionSemigroupTransform : SemigroupTransform.
      set (D := A : Semigroup).
      destruct A as [[crA chooseA equalA reflA symA transA] opA assocA op_pres_eqA fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] opB assocB op_pres_eqB fnB appB app_pres_eqB];
      simpl in *.
      set (appB2 := fun l x => phi' f (appB l (phi f x))).
      apply (unionSemigroupTransform_SgEq D fnA fnB appA appB2).
      intros x y m n; apply (app_pres_eqA x y m n).
      red; simpl in *.
      intros x y m n p q. unfold appB2. unfold D in *; clear D.
      apply (pres_eq' f). apply app_pres_eqB; auto. rewrite p. auto.
   Defined.
   
   Lemma unionSTf_proj1 : IdSmgIso unionSemigroupTransform A.
   Proof. unfold unionSemigroupTransform.
      destruct A; destruct setoid;
      destruct B; destruct setoid. simpl in *.
      unfold unionSemigroupTransform_SgEq; simpl.
      unfold semigroupST; simpl; auto.
   Defined.
   
   Lemma unionSTf_proj2 : IdTfIso unionSemigroupTransform (unionTransform A B (IdSmgIso__IdDsIso f)).
   Proof. unfold unionSemigroupTransform;
      destruct A; destruct setoid;
      destruct B; destruct setoid; simpl in *.
      unfold semigroupST; simpl; auto.
   Defined.

(*
   Definition unionSemigroupTransform : SemigroupTransform.
      destruct (liftSTfIso A B iso) as [x [iso' [p1 p2]]].
      assert (q := fun F app_f app_pres_eq_f =>
         unionSemigroupTransform_SgEq
            A
            (fn A)
            F
            (app A)
            app_f
            (app_pres_eq A)
            app_pres_eq_f
      ).
      assert (p3 := DsEq_sym p1).
      unfold DsEq in *. clear p1 p2.
      destruct A; destruct x; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.
      destruct p3.
      apply (q fn0 app0 app_pres_eq0).
   Defined.
*)

End UnionIso.