Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Semigroups.Product.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Product.

   Variable A B : SemigroupTransform.
   
   Definition prodSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (prodSemigroup A B) (prodTransform A B) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*).

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope Transform_scope.
   Open Scope SemigroupTransform_scope.
   Open Scope Semigroup_scope.
   
   Lemma distributive : 
      Distributive A * Distributive B -> Distributive prodSemigroupTransform.
   Proof. intros [da db] [x1 x2] [y1 y2] [f1 f2].
      dseq_u; simpl; toProp; split; dseq_f.
      rewrite (da x1 y1 f1); auto.
      rewrite (db x2 y2 f2); auto.
   Qed.

   Lemma distributive_comp : 
      Distributive_comp A + Distributive_comp B -> Distributive_comp prodSemigroupTransform.
   Proof. intros [[x1 [y1 [f1 da]]] | [x2 [y2 [f2 db]]]].
      set (b := choose B); set(f := choose (fn B)).
      exists (x1, b); exists(y1, b); exists (f1, f).
      simpl; negb_p; dseq_f; toProp; auto.
      set (a := choose A); set(f := choose (fn A)).
      exists (a, x2); exists(a, y2); exists (f, f2).
      simpl; negb_p; dseq_f; toProp; auto.
   Defined.
   
   Lemma isCommutative_back_a : IsCommutative prodSemigroupTransform -> IsCommutative A.
   Proof. intros comm x y.
      set (b := choose B).
      assert (p := comm (x, b) (y, b)); dseq_u; simpl in p; dseq_f; toProp; destruct p;
      dseq_f; auto.
   Qed.

   Lemma isCommutative_back_b : IsCommutative prodSemigroupTransform -> IsCommutative B.
   Proof. intros comm x y.
      set (a := choose A).
      assert (p := comm (a, x) (a, y)); dseq_u; simpl in p; dseq_f; toProp; destruct p;
      dseq_f; auto.
   Qed.

   Lemma isIdempotent_back_a : IsIdempotent prodSemigroupTransform -> IsIdempotent A.
   Proof. intros idem x.
      set(b := choose B).
      assert (p := idem (x, b)); dseq_u; simpl in p; dseq_f; toProp; destruct p; dseq_f; auto.
   Qed.
 
   Lemma isIdempotent_back_b : IsIdempotent prodSemigroupTransform -> IsIdempotent B.
   Proof. intros idem x.
      set(a := choose A).
      assert (p := idem (a, x)); dseq_u; simpl in p; dseq_f; toProp; destruct p; dseq_f; auto.
   Qed.
   
   Lemma inflationary : Inflationary A * Inflationary B -> Inflationary prodSemigroupTransform.
   Proof. intros [ia ib] comm idem [x1 x2] [f1 f2].
      dseq_u; simpl. toProp; split.
      apply ia. apply isCommutative_back_a; auto. apply isIdempotent_back_a; auto.
      apply ib. apply isCommutative_back_b; auto. apply isIdempotent_back_b; auto.
   Qed.

   Lemma inflationary_comp : Inflationary_comp A + Inflationary_comp B -> Inflationary_comp prodSemigroupTransform.
   Proof. intros p comm idem. 
      assert(A_comm := isCommutative_back_a comm).
      assert(A_idem := isIdempotent_back_a idem).
      assert(B_comm := isCommutative_back_b comm).
      assert(B_idem := isIdempotent_back_b idem).
      destruct p as [[x1 [f1 ia]] | [x2 [f2 ib]]]; auto.
      exists (x1, choose B); exists (f1, choose (fn B)).
      simpl; negb_p. toProp; auto.
      exists (choose A, x2); exists (choose (fn A), f2).
      simpl; negb_p. toProp; auto.
   Qed.

   Lemma deflationary : Deflationary A * Deflationary B -> Deflationary prodSemigroupTransform.
   Proof. intros [ia ib] comm idem [x1 x2] [f1 f2].
      dseq_u; simpl. toProp; split.
      apply ia. apply isCommutative_back_a; auto. apply isIdempotent_back_a; auto.
      apply ib. apply isCommutative_back_b; auto. apply isIdempotent_back_b; auto.
   Qed.

   Lemma deflationary_comp : Deflationary_comp A + Deflationary_comp B -> Deflationary_comp prodSemigroupTransform.
   Proof. intros p comm idem. 
      assert(A_comm := isCommutative_back_a comm).
      assert(A_idem := isIdempotent_back_a idem).
      assert(B_comm := isCommutative_back_b comm).
      assert(B_idem := isIdempotent_back_b idem).
      destruct p as [[x1 [f1 ia]] | [x2 [f2 ib]]]; auto.
      exists (x1, choose B); exists (f1, choose (fn B)).
      simpl; negb_p. toProp; auto.
      exists (choose A, x2); exists (choose (fn A), f2).
      simpl; negb_p. toProp; auto.
   Qed.
   
   Lemma strictInflationary : (StrictInflationary A * Inflationary B) + (StrictInflationary B * Inflationary A)
      -> StrictInflationary prodSemigroupTransform.
   Proof. intros [[sia ib] | [sib ia]] comm idem [x1 x2] [f1 f2];
      assert(A_comm := isCommutative_back_a comm);
      assert(A_idem := isIdempotent_back_a idem);
      assert(B_comm := isCommutative_back_b comm);
      assert(B_idem := isIdempotent_back_b idem).
      assert (p := sia A_comm A_idem x1 f1); assert (q := ib B_comm B_idem x2 f2). 
      simpl; negb_p. toProp; tauto.
      assert (p := ia A_comm A_idem x1 f1); assert (q := sib B_comm B_idem x2 f2). 
      simpl; negb_p. toProp; tauto.
   Qed.

   Lemma strictInflationary_comp : (StrictInflationary_comp A + Inflationary_comp B) *
      (StrictInflationary_comp B + Inflationary_comp A)
      -> StrictInflationary_comp prodSemigroupTransform.
   Proof. intros p comm idem.
      assert(A_comm := isCommutative_back_a comm);
      assert(A_idem := isIdempotent_back_a idem);
      assert(B_comm := isCommutative_back_b comm);
      assert(B_idem := isIdempotent_back_b idem).
      destruct p as [[X | Y] [Z | W]].
      destruct (X A_comm A_idem) as [x [f p]].
      destruct (Z B_comm B_idem) as [y [g q]].
      exists (x, y); exists (f, g); simpl; negb_p; toProp; tauto.
      destruct (W A_comm A_idem) as [x [f p]].
      exists (x, choose B); exists (f, choose (fn B)); simpl; negb_p; toProp; tauto.
      destruct (Y B_comm B_idem) as [x [f p]].
      exists (choose A, x); exists (choose (fn A), f); simpl; negb_p; toProp; tauto.
      destruct (W A_comm A_idem) as [x [f p]].
      destruct (Y B_comm B_idem) as [y [g q]].
      exists (x, y); exists (f, g); simpl; negb_p; toProp; tauto.
   Defined.

   Lemma strictDeflationary : (StrictDeflationary A * Deflationary B) + (StrictDeflationary B * Deflationary A)
      -> StrictDeflationary prodSemigroupTransform.
   Proof. intros [[sia ib] | [sib ia]] comm idem [x1 x2] [f1 f2];
      assert(A_comm := isCommutative_back_a comm);
      assert(A_idem := isIdempotent_back_a idem);
      assert(B_comm := isCommutative_back_b comm);
      assert(B_idem := isIdempotent_back_b idem).
      assert (p := sia A_comm A_idem x1 f1); assert (q := ib B_comm B_idem x2 f2). 
      simpl; negb_p. toProp; tauto.
      assert (p := ia A_comm A_idem x1 f1); assert (q := sib B_comm B_idem x2 f2). 
      simpl; negb_p. toProp; tauto.
   Qed.

   Lemma strictDeflationary_comp : (StrictDeflationary_comp A + Deflationary_comp B) *
      (StrictDeflationary_comp B + Deflationary_comp A)
      -> StrictDeflationary_comp prodSemigroupTransform.
   Proof. intros p comm idem.
      assert(A_comm := isCommutative_back_a comm);
      assert(A_idem := isIdempotent_back_a idem);
      assert(B_comm := isCommutative_back_b comm);
      assert(B_idem := isIdempotent_back_b idem).
      destruct p as [[X | Y] [Z | W]].
      destruct (X A_comm A_idem) as [x [f p]].
      destruct (Z B_comm B_idem) as [y [g q]].
      exists (x, y); exists (f, g); simpl; negb_p; toProp; tauto.
      destruct (W A_comm A_idem) as [x [f p]].
      exists (x, choose B); exists (f, choose (fn B)); simpl; negb_p; toProp; tauto.
      destruct (Y B_comm B_idem) as [x [f p]].
      exists (choose A, x); exists (choose (fn A), f); simpl; negb_p; toProp; tauto.
      destruct (W A_comm A_idem) as [x [f p]].
      destruct (Y B_comm B_idem) as [y [g q]].
      exists (x, y); exists (f, g); simpl; negb_p; toProp; tauto.
   Defined.

   Lemma hasId_back_a : HasIdentity prodSemigroupTransform -> HasIdentity A.
   Proof. intros [[ida idb] p].
      exists ida. intros x; split; simpl.
      destruct (p (x, choose B)) as [q _]; dseq_u; simpl in *; toProp; tauto.
      destruct (p (x, choose B)) as [_ q]; dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasId_back_b : HasIdentity prodSemigroupTransform -> HasIdentity B.
   Proof. intros [[ida idb] p].
      exists idb. intros x; split; simpl.
      destruct (p (choose A, x)) as [q _]; dseq_u; simpl in *; toProp; tauto.
      destruct (p (choose A, x)) as [_ q]; dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasId_back_eq : forall hasId : HasIdentity prodSemigroupTransform,
      projT1 hasId == (projT1 (hasId_back_a hasId), projT1 (hasId_back_b hasId)).
   Proof. intros [[id1 id2] p]. destruct (p (id1, id2)); simpl. auto. Defined.

   Lemma strict : Strict A * Strict B -> Strict prodSemigroupTransform.
   Proof. intros [sta stb] hasId [f1 f2]; red in sta, stb; simpl in sta, stb.
      assert (p1 := hasId_back_eq hasId);
      rewrite p1; simpl. dseq_u; simpl; toProp; split; [apply sta | apply stb]; auto.
   Defined.

   Lemma strict_comp : Strict_comp A + Strict_comp B
      -> Strict_comp prodSemigroupTransform.
   Proof. intros [sta | stb] hasId.
      destruct (sta (hasId_back_a hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (f, choose (fn B)). simpl. negb_p; toProp; tauto.
      destruct (stb (hasId_back_b hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (choose (fn A), f). simpl. negb_p; toProp; tauto.
   Defined.

End Product.