Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Semigroups.Lex.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Lex.

   Variable A B : SemigroupTransform.
   Variable A_comm   : IsCommutative A.
   Variable A_idem   : IsIdempotent A.
   Variable B_hasId  : HasIdentity B.
   Variable B_strict : Strict B.
   
   Definition lexSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (lexSemigroup A B A_comm A_idem B_hasId) (prodTransform A B) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*).

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope Transform_scope.
   Open Scope SemigroupTransform_scope.
   Open Scope Semigroup_scope.

   Lemma lexComp_equiv : forall x y, lexComp A x y = equiv <-> x == y.
   Proof. intros x y; split. intros p; copy_destruct (lexComp A x y) as h; rewrite h in p;
      try discriminate; rewrite lexComp_equiv in h; auto; toProp; simpl in *; dseq_f. destruct h as [h1 h2].
      dseq_f. rewrite <- h1, (A_comm x y); auto.
      intros h; rewrite <- (lexComp_pres_eq A x x x y), lexComp_refl; auto.
   Defined.

   Lemma lexComp_less : forall x y, lexComp A x y = less <-> x < y.
   Proof. intros x y; rewrite lexComp_less; auto; simpl in *; negb_p; toProp; tauto. Defined.

   Lemma lexComp_more : forall x y, lexComp A x y = more <-> y < x.
   Proof. intros x y; rewrite lexComp_more; auto; simpl in *; negb_p; toProp; tauto. Defined.

   Lemma lexComp_none : forall x y, lexComp A x y = none <-> x # y.
   Proof. intros x y; rewrite lexComp_none; auto; simpl in *; negb_p; toProp; tauto. Defined.

   Ltac lex_destruct_as x y h :=
      copy_destruct (lexComp A x y) as h; rewrite h;
      rewrite ?lexComp_equiv, ?lexComp_less, ?lexComp_more, ?lexComp_none in h.

   Tactic Notation "lex_destruct" constr(x) constr(y) := let h := fresh "h" in lex_destruct_as x y h.
   Tactic Notation "lex_destruct" constr(x) constr(y) "as" ident(h) := lex_destruct_as x y h.

   Lemma cond_id : Condensed B -> forall x (f : fn B), f |> x == id_B B B_hasId.
   Proof. intros cd x f; rewrite <- (B_strict B_hasId f); apply cd. Defined.
   
   Lemma distributive : 
      Distributive A * Distributive B * (Cancelative A + Condensed B) -> Distributive lexSemigroupTransform.
   Proof. intros [[da db] [ca | cb]] [x1 x2] [y1 y2] [f1 f2]; dseq_u; simpl;
      toProp; (split; [ apply da |]); dseq_f.
      lex_destruct (f1 |> x1) (f1 |> y1) as h.
      (* 1 *) rewrite <- (lexComp_pres_eq A x1 x1 x1 y1); [ | auto | apply (ca _ _ f1); auto];
      rewrite lexComp_refl; auto.
      (* 2 *) assert (x1 < y1). negb_p; toProp; destruct h as [h1 h2]; split;
         [ apply (ca _ _ f1); simpl; rewrite (da x1 y1 f1); apply h1
         | intros h; elim h2; dseq_f; rewrite <- (da y1 x1 f1), h; auto ].
      rewrite <- lexComp_less in H; rewrite H; auto.
      (* 3 *) assert (y1 < x1). negb_p; toProp; destruct h as [h1 h2]; split.
         apply (ca _ _ f1); simpl; rewrite (da y1 x1 f1); apply h1.
         intros h; elim h2; dseq_f; rewrite <- (da x1 y1 f1), h; auto.
      rewrite <- lexComp_more in H; rewrite H; auto.
      (* 4 *) assert (x1 # y1). negb_p; toProp; destruct h as [h1 h2]; split.
         intros h; elim h1; dseq_f; rewrite <- (da x1 y1 f1), h; auto.
         intros h; elim h2; dseq_f; rewrite <- (da y1 x1 f1), h; auto.
      rewrite <- lexComp_none in H; rewrite H; auto. apply B_strict.
      
      lex_destruct (f1 |> x1) (f1 |> y1) as h;
      lex_destruct x1 y1 as h1; auto;
      try (rewrite <- (db x2 y2 f2));
      try (apply cb);
      try (apply (cond_id cb)); auto.
   Defined.

   Lemma distributive_comp : 
         Distributive_comp A + Distributive_comp B + (Cancelative_comp A * Condensed_comp B) 
      -> Distributive_comp lexSemigroupTransform.
   Proof. intros [[[a [b [f da]]] | [x [y [g db]]]] | [[a [b [f [ca1 ca2]]]] [x [y [g db]]]]].
      exists (a, choose B); exists (b, choose B); exists (f, choose (fn B)); simpl.
      negb_p; rewrite da; auto.
      exists (choose A, x); exists (choose A, y); exists (choose (fn A), g); simpl.
      negb_p. rewrite lexComp_refl, lexComp_refl, db, orb_true_r; auto.
      

      rewrite <- lexComp_equiv in ca1; simpl in ca1.
      copy_destruct (lexComp A a b).
      (* 3.1 *) exists (a, x); exists (b, y); exists (f, g); simpl.
      rewrite ca1, ew; simpl; rewrite lexComp_equiv in ew; toProp; tauto.
      (* 3,2 *)
      copy_destruct (g |> x == g |> id_B B B_hasId); simpl in db. 
      exists (a, id_B B B_hasId); exists (b, y); exists (f, g); simpl.
      rewrite ew, ca1; negb_p; toProp; apply or_intror; intros h; elim db; dseq_f;
      rewrite ew0, h, (B_strict B_hasId g);
      destruct B_hasId as [id p]; destruct (p (g |> y)) as [p1 p2]; auto.
      exists (a, id_B B B_hasId); exists (b, x); exists (f, g); simpl.
      rewrite ew, ca1; negb_p; toProp; apply or_intror; intros h. bool_p; elim ew0. dseq_f.
      rewrite h, (B_strict B_hasId g). destruct B_hasId as [id p]; destruct (p (g |> x)) as [p1 p2]; simpl in *. 
      rewrite p1; auto.
      (* 3.3 *) 
      copy_destruct (g |> x == g |> id_B B B_hasId); simpl in db. 
      exists (a, y); exists (b, id_B B B_hasId); exists (f, g); simpl.
      rewrite ew, ca1; negb_p; toProp; apply or_intror; intros h; elim db; dseq_f;
      rewrite ew0, h, (B_strict B_hasId g);
      destruct B_hasId as [id p]; destruct (p (g |> y)) as [p1 p2]; auto.
      exists (a, x); exists (b, id_B B B_hasId); exists (f, g); simpl.
      rewrite ew, ca1; negb_p; toProp; apply or_intror; intros h. bool_p; elim ew0. dseq_f.
      rewrite h, (B_strict B_hasId g). destruct B_hasId as [id p]; destruct (p (g |> x)) as [p1 p2]; simpl in *. 
      rewrite p2; auto.
      (* 3.4 *) 
      copy_destruct (g |> x == g |> id_B B B_hasId); simpl in db. 
      exists (a, id_B B B_hasId); exists (b, y); exists (f, g); simpl.
      rewrite ca1, ew; simpl. negb_p; toProp; apply or_intror; intros h; elim db. dseq_f.
      rewrite ew0, h, (B_strict B_hasId g). destruct B_hasId as [id p]; destruct (p (g |> y)) as [p1 p2]; auto.
      exists (a, id_B B B_hasId); exists (b, x); exists (f, g); simpl.
      rewrite ca1, ew; simpl; negb_p; toProp; apply or_intror; intros h. bool_p; elim ew0. dseq_f.
      rewrite h, (B_strict B_hasId g). destruct B_hasId as [id p]; destruct (p (g |> x)) as [p1 p2]. simpl in *.
      rewrite p1; auto.
   Defined.

   (**************************************************************)
   (*             Commutative Idempotent properties              *)
   (**************************************************************)

   Lemma isCommutative_back : IsCommutative lexSemigroupTransform -> IsCommutative B.
   Proof.
         intros comm a b. simpl.
         assert (p := comm (choose A, a) (choose A, b)). dseq_u; simpl in p; toProp.
         rewrite lexComp_refl in p; trivial; simpl in p; tauto.
   Defined.
   
   Lemma isIdempotent_back : IsIdempotent lexSemigroupTransform -> IsIdempotent B.
   Proof.
         intros idem a. simpl.
         assert (p := idem (choose A, a)); dseq_u; simpl in p; toProp;
         rewrite lexComp_refl in p; trivial; simpl in p; tauto.
   Defined.
   
   Ltac lex_comm_idem comm idem :=
      assert (B_comm := isCommutative_back comm);
      assert (B_idem := isIdempotent_back idem).

   Lemma inflationary : Inflationary A * (StrictInflationary A + Inflationary B) 
      -> Inflationary lexSemigroupTransform.
   Proof. intros [ia [sia | ib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; toProp; (split; [ apply ia; auto |]).
      (* 1 *) assert (x1 < f1 |> x1) as h; [ apply sia; auto | rewrite <- lexComp_less in h; rewrite h; dseq_f; auto ].
      (* 2 *) 
      lex_comm_idem comm idem.
      lex_destruct x1 (f1 |> x1) as h.
      apply ib; auto.
      dseq_f; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h2; apply ia; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto.
   Defined.
      
   Lemma inflationary_comp :
      Inflationary_comp A + (StrictInflationary_comp A * Inflationary_comp B)
      -> Inflationary_comp lexSemigroupTransform.
   Proof. intros [ia | [sia ib]] comm idem; lex_comm_idem comm idem.
      destruct (ia A_comm A_idem) as [x [f p]];
      exists (x, choose B); exists (f, choose (fn B)); simpl in *; negb_p; toProp; dseq_f; auto.
      destruct (sia A_comm A_idem) as [a [g q]];
      destruct (ib B_comm B_idem) as [x [f p]];
      exists (a, x); exists (g, f). simpl in *.
      negb_p; toProp. intuition. apply or_intror.
      lex_destruct a (g |> a) as h; negb_p; toProp;
      [ auto
      | tauto
      | intros q; elim p; dseq_f; rewrite q, (B_idem x); auto
      | tauto ].
   Defined.

   Lemma deflationary : Deflationary A * (StrictDeflationary A + Deflationary B) 
      -> Deflationary lexSemigroupTransform.
   Proof. intros [ia [sia | ib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; toProp; (split; [ apply ia; auto |]).
      (* 1 *) assert (f1 |> x1 < x1) as h; [ apply sia; auto | rewrite <- lexComp_less in h; rewrite h; dseq_f; auto ].
      (* 2 *) 
      lex_comm_idem comm idem.
      lex_destruct (f1 |> x1) x1 as h.
      apply ib; auto.
      dseq_f; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h2; apply ia; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto.
   Defined.
      
   Lemma deflationary_comp :
      Deflationary_comp A + (StrictDeflationary_comp A * Deflationary_comp B)
      -> Deflationary_comp lexSemigroupTransform.
   Proof. intros [ia | [sia ib]] comm idem; lex_comm_idem comm idem.
      destruct (ia A_comm A_idem) as [x [f p]];
      exists (x, choose B); exists (f, choose (fn B)); simpl in *; negb_p; toProp; dseq_f; auto.
      destruct (sia A_comm A_idem) as [a [g q]];
      destruct (ib B_comm B_idem) as [x [f p]];
      exists (a, x); exists (g, f). simpl in *.
      negb_p; toProp. intuition. apply or_intror.
      lex_destruct (g |> a) a as h; negb_p; toProp.
      auto.
      tauto.
      intros q; elim p; dseq_f; rewrite <- q, (B_idem x); auto.
      tauto.
   Defined.
   
   Lemma strictInflationary :
      StrictInflationary A + Inflationary A * StrictInflationary B
      -> StrictInflationary lexSemigroupTransform.
   Proof. intros [sia | [ia sib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; negb_p; toProp; lex_comm_idem comm idem.
      (* 1 *) assert (x1 < f1 |> x1) as h; [ apply sia; auto |].
      rewrite <- lexComp_less in h; rewrite h; rewrite lexComp_less in h; 
      negb_p; toProp; intuition; dseq_f; auto.
      (* 2 *) rewrite (lexComp_swap _ A_comm (f1 |> x1) x1).
      lex_destruct x1 (f1 |> x1) as h; simpl;
      [ assert (q := sib B_comm B_idem x2 f2); negb_p; toProp; intuition
      | negb_p; toProp; intuition; dseq_f; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h2; apply ia; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto ].
   Defined.

   Lemma strictInflationary_comp :
      StrictInflationary_comp A * (Inflationary_comp A + StrictInflationary_comp B)
      -> StrictInflationary_comp lexSemigroupTransform.
   Proof. intros [sia [ia | sib]] comm idem; lex_comm_idem comm idem.
      (* 1 *) destruct (ia A_comm A_idem) as [b [k p2]].
      exists (b, choose B); exists (k, choose (fn B)).
      simpl; negb_p; toProp. rewrite (lexComp_swap _ A_comm (k |> b) b).
      lex_destruct b (k |> b) as h; simpl; auto.
      (* 2 *) destruct (sia A_comm A_idem) as [a [g p1]].
      destruct (sib B_comm B_idem) as [b [k p2]].
      exists (a, b); exists (g, k); simpl; negb_p; toProp.
      rewrite (lexComp_swap _ A_comm (g |> a) a);
      lex_destruct a (g |> a) as h; simpl; negb_p; toProp; try tauto.
   Defined.

   Lemma strictDeflationary :
      StrictDeflationary A + Deflationary A * StrictDeflationary B
      -> StrictDeflationary lexSemigroupTransform.
   Proof. intros [sia | [ia sib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; negb_p; toProp; lex_comm_idem comm idem.
      (* 1 *) assert (f1 |> x1 < x1) as h; [ apply sia; auto |].
      rewrite <- lexComp_less in h; rewrite h; rewrite lexComp_less in h; 
      negb_p; toProp; intuition; dseq_f; auto.
      (* 2 *) rewrite (lexComp_swap _ A_comm x1 (f1 |> x1)).
      lex_destruct (f1 |> x1) x1 as h; simpl;
      [ assert (q := sib B_comm B_idem x2 f2); negb_p; toProp; intuition
      | negb_p; toProp; intuition; dseq_f; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h2; apply ia; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto ].
   Defined.

   Lemma strictDeflationary_comp :
      StrictDeflationary_comp A * (Deflationary_comp A + StrictDeflationary_comp B)
      -> StrictDeflationary_comp lexSemigroupTransform.
   Proof. intros [sia [ia | sib]] comm idem; lex_comm_idem comm idem.
      (* 1 *) destruct (ia A_comm A_idem) as [b [k p2]].
      exists (b, choose B); exists (k, choose (fn B)).
      simpl; negb_p; toProp. rewrite (lexComp_swap _ A_comm (k |> b) b).
      lex_destruct b (k |> b) as h; simpl; auto.
      (* 2 *) destruct (sia A_comm A_idem) as [a [g p1]].
      destruct (sib B_comm B_idem) as [b [k p2]].
      exists (a, b); exists (g, k); simpl; negb_p; toProp.
      rewrite (lexComp_swap _ A_comm (g |> a) a);
      lex_destruct a (g |> a) as h; simpl; negb_p; toProp; try tauto.
   Defined.

   (**************************************************************)
   (*                    Identity properties                     *)
   (**************************************************************)

   Lemma hasId_back_a : HasIdentity lexSemigroupTransform -> HasIdentity A.
   Proof. intros [[ida idb] p].
      exists ida. intros x; split; simpl.
      destruct (p (x, choose B)) as [q _]; dseq_u; simpl in *; toProp; tauto.
      destruct (p (x, choose B)) as [_ q]; dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasId_back_b : HasIdentity lexSemigroupTransform -> HasIdentity B.
   Proof. intros [[ida idb] p].
      exists idb. intros x; destruct (p (ida, x)) as [p1 p2]; dseq_u; simpl in *.
      rewrite lexComp_refl in p1, p2; auto; toProp; tauto.
   Defined.

   Lemma hasId_back_eq : forall hasId : HasIdentity lexSemigroupTransform,
      projT1 hasId == (projT1 (hasId_back_a hasId), projT1 (hasId_back_b hasId)).
   Proof. intros [[id1 id2] p]. destruct (p (id1, id2)); simpl. auto. Defined.

   Lemma strict : Strict A * Strict B -> Strict lexSemigroupTransform.
   Proof. intros [sta stb] hasId [f1 f2]; red in sta, stb; simpl in sta, stb.
      assert (p1 := hasId_back_eq hasId);
      rewrite p1; simpl. dseq_u; simpl; toProp; split; [apply sta | apply stb]; auto.
   Defined.

   Lemma strict_comp : Strict_comp A + Strict_comp B
      -> Strict_comp lexSemigroupTransform.
   Proof. intros [sta | stb] hasId.
      destruct (sta (hasId_back_a hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (f, choose (fn B)). simpl. negb_p; toProp; tauto.
      destruct (stb (hasId_back_b hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (choose (fn A), f). simpl. negb_p; toProp; tauto.
   Defined.
      
   Close Scope SemigroupTransform_scope.

End Lex.