Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.OrderTransformProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.Constructions.Transforms.FSets.
Require Import Metarouting.Constructions.Transforms.FMinSets.
Require Import Metarouting.Constructions.SemigroupTransforms.FSets.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section FMinSets.

   Variable A : OrderTransform.
   Variable mon : Monotone A.
   Variable antisym : Antisym A.
   
   Definition msetsSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (msetUnionSemigroup A) (msetsTransform A mon antisym) (dsEq_refl _).

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Open Scope OrderTransform_scope.

   Ltac toMSet :=
      unfold eq_mset in *;
      unfold mmap_app in *;
      unfold mset_union in *;
      repeat rewrite (min_min A) in *;
      repeat rewrite <- (min_fmap A mon antisym) in *;
      repeat rewrite <- (min_union_l A) in *;
      repeat rewrite <- (min_union_r A) in *.
      
   Ltac toMSet_u :=
      dseq_u; simpl in *;
      toMSet.
   
   Lemma distributive : Distributive msetsSemigroupTransform.
   Proof. intros x y f. simpl; toMSet_u. apply min_pres_eq.
      assert (p := SemigroupTransforms.FSets.distributive A x y f). simpl in p. auto.
   Qed.
   
   Lemma inflationary : Increasing A -> Inflationary msetsSemigroupTransform.
   Proof. intros inc _ _ x f. toMSet_u.
      dseq_f; rewrite <- (upper_eq antisym); intros a.
      rewrite upper_union; auto.
      rewrite bool_eq; split; intros h.
      toProp; destruct h as [h|h]; auto.
      destruct (upper_fmap_elim A antisym _ _ _ h) as [b [p1 p2]].
      destruct (upper_mem_elim A _ _ p2) as [c [p3 p4]]. simpl in *.
      apply upper_mem_intro2 with c; simpl in *; auto.
      rewrite (min_mem A) in p3; destruct p3 as [p3 _]; auto.
      apply le_trans with b; auto.
      apply le_trans with (f |> b); auto.
      
      toProp; tauto.
   Qed.
   
   Lemma inflationary_comp : Increasing_comp A -> Inflationary_comp msetsSemigroupTransform.
   Proof. intros [x [f inc]] _ _.
      exists (x :: nil); exists f.
      toMSet_u.
      unfold min, union, fmap_app; simpl; unfold eq_fset; simpl.
      assert (x == f |> x = false) as p.
         bool_p; toProp; intros q; apply inc; dseq_f; rewrite <-q; apply le_refl.
      rewrite p; simpl.
      negb_p; repeat rewrite le_refl; simpl.
      assert (x <= f |> x = false) as p1.
         bool_p; toProp; tauto.
      rewrite p1; simpl.
      copy_destruct (f |> x <= x); rewrite ew; simpl.
      negb_p. rewrite p. simpl. toProp; bool_p; tauto.
      rewrite refl; simpl.
      negb_p. assert (f |> x == x = false) as p2.
         bool_p; intros q; apply p; dseq_f; rewrite q; auto.
      rewrite p2; auto.
   Defined.

   Lemma deflationary : Decreasing A -> Deflationary msetsSemigroupTransform.
   Proof. intros inc _ _ x f. toMSet_u.
      dseq_f; rewrite <- (upper_eq antisym); intros a.
      rewrite upper_union; auto.
      rewrite bool_eq; split; intros h.
      toProp; destruct h as [h|h]; auto.
      destruct (upper_mem_elim A _ _ h) as [b [p1 p2]]. simpl in *.
      apply (upper_fmap_intro _ mon antisym) with b.
      apply le_trans with (f |> a); auto.
      apply upper_mem_intro with b; auto.
      
      toProp; auto.
   Qed.
   
   Lemma deflationary_comp : Decreasing_comp A -> Deflationary_comp msetsSemigroupTransform.
   Proof. intros [x [f def]] _ _.
      exists (x :: nil); exists f.
      toMSet_u; unfold min, union, fmap_app; simpl; unfold eq_fset; simpl.
      negb_p; repeat rewrite le_refl; simpl.
      assert (f |> x == x = false) as p1.
         bool_p; toProp; intros h; apply def; dseq_f; rewrite h; apply le_refl.
      rewrite p1; simpl.
      negb_p; repeat rewrite le_refl; simpl.
      assert (f |> x <= x = false) as p2.
         bool_p; toProp; tauto.
      rewrite p2; simpl.
      copy_destruct (x <= f |> x); rewrite ew; simpl; negb_p.
      rewrite p1; simpl; toProp; bool_p. tauto.
      assert (x == f |> x = false) as p3.
         bool_p; intros h; apply p1; dseq_f; rewrite <- h; auto.
      rewrite p3; simpl; toProp; bool_p; tauto.
   Defined.

   Lemma strictInflationary_comp : StrictInflationary_comp msetsSemigroupTransform.
   Proof. intros _ _. exists nil; exists (choose (Transform.fn A)).
      negb_p; compute. auto.
   Defined.

   Lemma strictDeflationary_comp : StrictDeflationary_comp msetsSemigroupTransform.
   Proof. intros _ _. exists nil; exists (choose (Transform.fn A)).
      negb_p; compute. auto.
   Defined.
   
   Lemma strict : Strict msetsSemigroupTransform.
   Proof. intros hasId f.
      assert ((projT1 hasId) == nil) as h.
         set (p := Semigroups.FMinSetsUnion.hasIdentity A).
         apply (uniqueId (msetUnionSemigroup A) hasId p).
      rewrite h. simpl. compute; auto.
   Qed.

End FMinSets.