Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Transforms.AddZero.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section AddZero.

   Variable A : SemigroupTransform.
   
   Definition addZeroSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (unionSemigroup A unitSemigroup) (addZeroTransform A) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*).

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)

   Open Scope Transform_scope.
   Open Scope Semigroup_scope.
   Open Scope SemigroupTransform_scope.

   Lemma distributive : Distributive A -> Distributive addZeroSemigroupTransform.
   Proof. intros da [x|[]] [y|[]] [f|[]]; dseq_u; simpl; dseq_f; auto. Qed.
   
   Lemma distributive_comp : Distributive_comp A -> Distributive_comp addZeroSemigroupTransform.
   Proof. intros [x [y [f da]]];
      exists (inl _ x); exists (inl _ y); exists (inl _ f); dseq_u; simpl; dseq_f; auto.
   Defined.
   
   Lemma isCommutative_back : IsCommutative addZeroSemigroupTransform -> IsCommutative A.
   Proof. intros comm x y.
      assert (p := comm (inl _ x) (inl _ y)); dseq_u; simpl in p. auto.
   Qed.
   
   Lemma isIdempotent_back : IsIdempotent addZeroSemigroupTransform -> IsIdempotent A.
   Proof. intros idem x.
      assert (p := idem (inl _ x)); dseq_u; simpl in p. auto.
   Qed.
   
   Lemma inflationary : Inflationary A -> Inflationary addZeroSemigroupTransform.
   Proof. intros inf comm idem [x|[]] [f|[]]; dseq_u; simpl; dseq_f; auto.
      apply inf. apply isCommutative_back; auto. apply isIdempotent_back; auto.
   Qed.
   
   Lemma inflationary_comp : Inflationary_comp A -> Inflationary_comp addZeroSemigroupTransform.
   Proof. intros inf comm idem.
      assert (A_comm := isCommutative_back comm);
      assert (A_idem := isIdempotent_back idem).
      destruct (inf A_comm A_idem) as [x [f p]].
      exists (inl _ x); exists (inl _ f); auto.
   Defined.
   
   Lemma deflationary_comp : Deflationary_comp addZeroSemigroupTransform.
   Proof. intros _ _. exists (inl _ (choose A)); exists (inr _ tt); compute; auto. Defined.
   
   Lemma strictInflationary_comp : StrictInflationary_comp addZeroSemigroupTransform.
   Proof. exists (inr _ tt); exists (inl _ (choose (fn A))); dseq_u; simpl; auto. Defined.

   Lemma strictDeflationary_comp : StrictDeflationary_comp addZeroSemigroupTransform.
   Proof. exists (inr _ tt); exists (inl _ (choose (fn A))); dseq_u; simpl; auto. Defined.

End AddZero.
