Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section LeftNaturalOrder.

   Variable S : Semigroup.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.

   Open Scope Semigroup_scope.

   Definition le (x y : S) := x + y == x.
   
   Lemma le_refl : Reflexive le.
   Proof. apply idem. Defined.

   (*
   Lemma le_antisym : Antisymmetric _ le (eq S).
   Proof. red; intros. unfold le in *. rewrite (comm x y) in H. rewrite <- H, H0; setoid_reflexivity. Defined.
   *)

   Lemma le_trans : Transitive le.
   Proof. intros x y z p q; unfold le in *; dseq_f;
     rewrite <- p at 1; rewrite (assoc _ x y z), q; auto.
   Defined.
   
   (*
   Lemma le_dec : Decidable _ le.
   Proof.
      red; intros. unfold le.
      apply (isDec S).
   Defined.
   *)
   
   Lemma le_pres_eq : RelPreserves le.
   Proof. intros x y u v p q h; unfold le in *; dseq_f; rewrite <- p, <- q; auto. Defined.

   Definition leftNaturalOrder :=
      Build_Preorder
         le_refl
         le_trans
         le_pres_eq.

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma hasTop : HasIdentity S -> HasTop leftNaturalOrder.
   Proof. intros [a ia]; exists a; intros x; destruct (ia x); unfold le; auto. Defined.

   Lemma hasTop_comp : HasIdentity_comp S -> HasTop_comp leftNaturalOrder.
   Proof. intros id x. destruct (id x) as [y p]; exists y. 
      simpl; unfold le; toProp. destruct p as [p|p]; auto.
      intros h; elim p; dseq_f; rewrite (comm x y); auto.
   Defined.
   
   Lemma hasBottom : HasAnnihilator S -> HasBottom leftNaturalOrder.
   Proof. intros [a ia]; exists a; intros x; destruct (ia x); unfold le; auto. Defined.
   
   Lemma hasBottom_comp : HasAnnihilator_comp S -> HasBottom_comp leftNaturalOrder.
   Proof. intros id x. destruct (id x) as [y p]; exists y. 
      simpl; unfold le; toProp. destruct p as [p|p]; auto.
      intros h; elim p; dseq_f; rewrite (comm y x); auto.
   Defined.

   Lemma total : IsSelective S -> Total leftNaturalOrder.
   Proof. intros sl x y; simpl; unfold le; destruct (sl x y); auto.
      rewrite (comm y x); auto.
   Defined.

   Lemma total_comp : IsSelective_comp S -> Total_comp leftNaturalOrder.
   Proof. intros [a [b [p p']]]. exists a; exists b; split; simpl; unfold le; auto.
      rewrite (comm b a); trivial.
   Defined.

   Lemma antisym : Antisym leftNaturalOrder.
   Proof. intros x y [p q]; simpl in *; unfold le in *; dseq_f; rewrite <- q, (comm y x), p; auto. Defined.
   
(*
   (* This is an IFF-rule !!! *)
   Lemma finiteLeastElms : (HasAnnihilator S \/ HasAnnihilator_comp S) -> FiniteLeastElms leftNaturalOrder.
   Proof. intros [[c [cl cr]] | nc]; red.
      exists (c :: nil). intros x.
      unfold least. simpl. rewrite orb_false_r.
      split; intros h. apply eqdec_sym, eqdec_true_intro. apply h.
      red in cl, cr. unfold le. auto. intros. unfold le in H.
      rewrite <- H. assert (p := eqdec_true h). rewrite p.
      red in cl, cr. auto.
      exists (@nil S). simpl.
      intros; split; intros h; try discriminate.
      unfold least in h. red in nc. unfold not_annihilator in nc.
      destruct (nc x) as [[y py] | [y py]]; elim py; clear py.
      assert (p := h (x + y)). apply p. simpl. unfold le. rewrite (comm (x + y) x).
      rewrite <- (assoc _ _ (isSemigroup S) x x y). rewrite (idem x). setoid_reflexivity.
      assert (p := h (y + x)). apply p. simpl. unfold le. 
      rewrite (assoc _ _ (isSemigroup S) y x x). rewrite (idem x). setoid_reflexivity.
   Defined.

   Definition finiteRightIds (S : Semigroup) := 
      Exists l : list S, forall x : S, right_identity _ x <-> existsb (eqdec x) l = true.
   Definition finiteLeftIds (S : Semigroup):= 
      Exists l : list S, forall x : S, left_identity _ x <-> existsb (eqdec x) l = true.
*)
(*
   Lemma finiteGreatestElms : finiteRightIds S -> FiniteGreatestElms leftNaturalOrder.
   Proof. intros [l p]; red; exists l; intros x;
      assert (h := p x); clear p;
      rewrite <- h; clear h;
      unfold greatest, right_identity; simpl; unfold le.
      split; intros h y. apply (h (y + x)).
*)      
        
   
   (*
   Lemma finiteGreatestElms : (HasIdentity S \/ HasIdentity_comp S) -> FiniteGreatestElms leftNaturalOrder.
   Proof. intros [[c [cl cr]] | nc]; red.
      exists (c :: nil). intros x h.
      red in h. simpl in h. unfold le in h.
      simpl. rewrite orb_false_r. apply eqdec_sym; apply eqdec_true_intro; apply h. trivial.
      exists (@nil S); intros x h. simpl.
      red in h. simpl in h. unfold le in h.
      assert (p := nc x). destruct p as [[a p]|[a p]].
      elim p; clear p. assert (p := h a).
      apply (sym _ _ (isEquivalence S)). apply h. 
      rewrite (comm x a), (assoc _ _ (isSemigroup S) a x x), (idem x).
      setoid_reflexivity.
      rewrite (assoc _ _ (isSemigroup S) a x x), (idem x).
      setoid_reflexivity.
   *)

End LeftNaturalOrder.

