Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.


(* construct a different poset by reversing the order *)
Section Dual.

   Variable P : Preorder.

   Definition ge (x y : P) := le P y x.

   Lemma ge_refl : Reflexive ge.
   Proof. apply le_refl. Defined.
   
   Lemma ge_trans : Transitive ge.
   Proof. intros x y z p q; unfold ge in *; apply (@le_trans P z y x); auto. Defined.

   Lemma ge_pres_eq : RelPreserves ge.
   Proof. red; unfold ge; intros; eapply le_pres_eq; eauto. Defined.

   Definition dualPreorder :=
      Build_Preorder
         ge_refl    (* le_refl *)
         ge_trans   (* le_trans *)
         ge_pres_eq (* le_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma hasTop : HasBottom P -> HasTop dualPreorder.
   Proof. intros [b bb]. red. exists b; red; red in bb; intros x; simpl; apply bb. Defined.
   
   Lemma hasTop_comp : HasBottom_comp P -> HasTop_comp dualPreorder.
   Proof. intros h x; destruct (h x) as [a pa]; exists a; apply pa. Defined.
   
   Lemma hasBottom : HasTop P -> HasBottom dualPreorder.
   Proof. intros [t tt]; red; exists t; red; red in tt; intros x; simpl; apply tt. Defined.
   
   Lemma hasBottom_comp : HasTop_comp P -> HasBottom_comp dualPreorder.
   Proof. intros h x; destruct (h x) as [a pa]; exists a; apply pa. Defined.

   Lemma total : Total P -> Total dualPreorder.
   Proof. intros tp x y. apply (tp y x). Defined.
   
   Lemma total_comp : Total_comp P -> Total_comp dualPreorder.
   Proof. intros [x [y tp]]; red; exists y; exists x; trivial. Defined.

   Lemma antisym : Antisym P -> Antisym dualPreorder.
   Proof. intros asym x y [p q]; apply asym; split; auto. Defined.

   Lemma antisym_comp : Antisym_comp P -> Antisym_comp dualPreorder.
   Proof. intros [x [y asym]]; exists x; exists y; tauto. Defined.


(*   
   Lemma finiteLeastElms : FiniteGreatestElms P -> FiniteLeastElms dualPreorder.
   Proof. intros [l pl]; red; exists l. intros x; rewrite <- pl. split; trivial. Defined.
   
   Lemma finiteLeastElms_comp : FiniteGreatestElms_comp P -> FiniteLeastElms_comp dualPreorder.
   Proof. intros fg l. destruct (fg l) as [x [[p0 p1]|[p0 p1]]]; exists x; [apply inl|apply inr]; split; trivial. Defined.

   Lemma finiteGreatestElms : FiniteLeastElms P -> FiniteGreatestElms dualPreorder.
   Proof. intros [l pl]; red; exists l. intros x; rewrite <- pl; split; trivial. Defined.
   
   Lemma finiteGreatestElms_comp : FiniteLeastElms_comp P -> FiniteGreatestElms_comp dualPreorder.
   Proof. intros fg l. destruct (fg l) as [x [[p0 p1]|[p0 p1]]]; exists x; [apply inl | apply inr]; split; trivial. Defined.
*)

End Dual.
