Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section AnnTop.

   Variable S : Semigroup.
   Variable hasAnn : HasAnnihilator S.

   Open Scope Semigroup_scope.
   
   Definition ann := projT1 hasAnn.

   Definition ann_le (x y : S) := 
      (x == y) || (y == ann).
   
   Lemma le_refl : Reflexive ann_le.
   Proof. intros x; unfold ann_le; rewrite refl; simpl; auto. Qed.

   Lemma le_trans : Transitive ann_le.
   Proof. intros x y z p q; unfold ann_le in *; dseq_f.
     toProp; destruct p as [p|p]; destruct q as [q|q]; simpl in *; dseq_f.
     rewrite p, q; auto.
     auto.
     rewrite <- q, p; auto. 
     auto.
   Qed.
   
   Lemma le_pres_eq : RelPreserves ann_le.
   Proof. intros x y u v p q h; unfold ann_le in *; dseq_f.
      toProp; destruct h as [h|h]; dseq_f.
      rewrite <- p, <- q; auto.
      rewrite <- q; auto.
   Qed.

   Definition annTopPreorder :=
      Build_Preorder
         le_refl
         le_trans
         le_pres_eq.

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma hasTop : HasTop annTopPreorder.
   Proof. exists ann. intros x; simpl; unfold ann_le. toProp; dseq_f; auto. Qed.
   
   Lemma hasBottom : IsSingleton S + TwoElements S -> HasBottom annTopPreorder.
   Proof. intros [[x sg] | [x [y p]]].
      exists x. intros y. simpl; unfold ann_le. toProp; dseq_f; rewrite (sg x), (sg y); auto.
      copy_destruct (x == ann).
      exists y; intros z; simpl; unfold ann_le; toProp; dseq_f.
      destruct (p z) as [p1 [p2 | p2]]; rewrite <- ew; rewrite p2; auto.
      assert (y == ann) as w.
         destruct (p ann) as [p1 [p2 | p2]].
            bool_p; elim ew; dseq_f; rewrite p2; auto.
            rewrite p2; auto.
      exists x; intros z; simpl; unfold ann_le; toProp; dseq_f.
      destruct (p z) as [p1 [p2 | p2]]; rewrite <- w; rewrite p2; auto.
   Defined.
   
   Lemma hasBottom_comp : IsSingleton_comp S * TwoElements_comp S -> HasBottom_comp annTopPreorder.
   Proof. intros [sg te]. set (a := choose S).
      destruct (sg a) as [b pb].
      destruct (te a b) as [c pc].
      assert (Exists x y, x != ann /\ y != ann /\ x != y) as q.
         copy_destruct (a == ann).
         exists b; exists c. toProp; dseq_f. rewrite <- ew.
         destruct pc as [pc | pc].
            elim pb; dseq_f; rewrite pc; auto.
            split. tauto. split. tauto.
            intros h; destruct pc as [_ pc]; apply pc; dseq_f; rewrite h; auto.
         copy_destruct (b == ann).
         exists a; exists c. rewrite ew; simpl; split; auto.
         toProp; dseq_f.
         destruct pc as [pc | pc].
            elim pb; dseq_f; rewrite pc; auto.
            rewrite <- ew0. split. tauto.
            intros h; destruct pc as [pc _]; apply pc; dseq_f; rewrite h; auto.
         exists a; exists b. rewrite ew, ew0; simpl; split; auto.
         split; auto. toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      destruct q as [x [y [h1 [h2 h3]]]].
      intros z.
         copy_destruct (z == x).
         exists y. simpl; unfold ann_le; negb_p.
         rewrite h2. toProp; dseq_f; rewrite ew; auto.
         exists x; simpl; unfold ann_le; negb_p.
         simpl in *; rewrite ew, h1; auto.
   Defined.
   
   Lemma total : IsSingleton S + TwoElements S -> Total annTopPreorder.
   Proof. intros [[a sg]|[a [b p]]].
      intros x y. simpl; unfold ann_le. toProp; dseq_f; rewrite (sg x), (sg y); auto.
      destruct (p ann) as [p1 [p2 | p2]].
      intros x y. simpl; unfold ann_le.
      toProp; dseq_f.
      destruct (p x) as [_ [p3 | p3]]; rewrite p3.
         rewrite p2; auto.
         destruct (p y) as [_ [p4 | p4]]; rewrite p4.
         rewrite p2; auto.
         auto.
      intros x y. simpl; unfold ann_le.
      toProp; dseq_f.
      destruct (p x) as [_ [p3 | p3]]; rewrite p3.
         destruct (p y) as [_ [p4 | p4]]; rewrite p4.
            auto.
            rewrite p2; auto.
         rewrite p2; auto.
   Qed.
   
   Lemma total_comp : IsSingleton_comp S * TwoElements_comp S -> Total_comp annTopPreorder.
   Proof. intros [sg te]. set (a := choose S).
      destruct (sg a) as [b pb].
      destruct (te a b) as [c pc].
      assert (Exists x y, x != ann /\ y != ann /\ x != y) as q.
         copy_destruct (a == ann).
         exists b; exists c. toProp; dseq_f. rewrite <- ew.
         destruct pc as [pc | pc].
            elim pb; dseq_f; rewrite pc; auto.
            split. tauto. split. tauto.
            intros h; destruct pc as [_ pc]; apply pc; dseq_f; rewrite h; auto.
         copy_destruct (b == ann).
         exists a; exists c. rewrite ew; simpl; split; auto.
         toProp; dseq_f.
         destruct pc as [pc | pc].
            elim pb; dseq_f; rewrite pc; auto.
            rewrite <- ew0. split. tauto.
            intros h; destruct pc as [pc _]; apply pc; dseq_f; rewrite h; auto.
         exists a; exists b. rewrite ew, ew0; simpl; split; auto.
         split; auto. toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      destruct q as [x [y [p1 [p2 p3]]]].
      exists x; exists y; simpl; unfold ann_le; negb_p; toProp; dseq_f.
      split; auto. split; auto.
      intros h; apply p3; dseq_f; rewrite h; auto.
   Defined.
   
   Lemma antisym : Antisym annTopPreorder.
   Proof. intros x y; simpl; unfold ann_le; negb_p; toProp. dseq_f.
      intros [[p1 | p1] [p2 | p2]].
      auto.
      auto.
      rewrite p2; auto.
      rewrite p1, p2; auto.
   Qed.
      
End AnnTop.
