Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.OrderTransformProperties.
Require Import Metarouting.Signatures.OrderTransformGlue.
Require Import Metarouting.Constructions.Preorders.RightNaturalOrder.
Require Import Coq.Bool.Bool.

Section RightNaturalOrder.

   Variable S : SemigroupTransform.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.
   Variable dist : Distributive S.

   Open Scope SemigroupTransform_scope.

   Definition rightNaturalOrder :=
      glueOTf (rightNaturalOrder S idem) S (dsEq_refl _). 

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Ltac rle_u := simpl in *; unfold rle; simpl in *.
   
   Lemma monotone : Monotone rightNaturalOrder.
   Proof. intros x y f; rle_u. dseq_f. intros h; rewrite <- (dist x y f), h; auto. Qed.
   
   Lemma embedding : Cancelative S -> Embedding rightNaturalOrder.
   Proof. intros ca _ x y f. rle_u.
      dseq_f; rewrite <- (dist x y f). intros h; auto.
      apply ca with f. auto.
   Qed.
   
   Lemma embedding_comp : Cancelative_comp S -> Embedding_comp rightNaturalOrder.
   Proof. intros [x [y [f [p1 p2]]]]. simpl in *.
      copy_destruct (x + y == y).
      assert (y + x == x = false) as p.
         bool_p; intro h; toProp; apply p2. dseq_f.
         rewrite <- ew, (comm x y), h; auto.
      exists y; exists x; exists f; rle_u. dseq_f.
      rewrite p1, p, (idem (f |> y)); split; auto.
      exists x; exists y; exists f; rle_u. dseq_f.
      rewrite p1, ew, (idem (f |> y)); split; auto.
   Defined.
   
   Lemma increasing : Deflationary S -> Increasing rightNaturalOrder.
   Proof. intros def x f; rle_u. rewrite (comm x (f |> x)). simpl. apply (def comm idem x f). Qed.
   
   Lemma increasing_comp : Deflationary_comp S -> Increasing_comp rightNaturalOrder.
   Proof. intros [x [f def]]; auto.
      exists x; exists f. rle_u; negb_p. rewrite (comm x (f |> x)). auto.
   Defined.

   Lemma decreasing : Inflationary S -> Decreasing rightNaturalOrder.
   Proof. intros def x f; rle_u. rewrite (comm (f |> x) x). simpl. apply (def comm idem x f). Qed.
   
   Lemma decreasing_comp : Inflationary_comp S -> Decreasing_comp rightNaturalOrder.
   Proof. intros [x [f def]]; auto.
      exists x; exists f. rle_u; negb_p. rewrite (comm (f |> x) x). auto.
   Defined.

End RightNaturalOrder.