Require Import Metarouting.Logic.Logic.
(* Require Import Metarouting.Logic.Relation. *)
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Coq.Lists.List.

(*********************************************************************)
(* setoid with a single element *)

Section Unit.

   Definition eq_unit (x y : unit) := true.
   
   Lemma eq_unit_refl : Reflexive eq_unit.
   Proof. compute; auto. Defined.
   
   Lemma eq_unit_sym : Symmetric eq_unit.
   Proof. compute; auto. Defined.
   
   Lemma eq_unit_trans : Transitive eq_unit.
   Proof. compute; auto. Defined.
   
   Definition unitDecSetoid : DecSetoid :=
      Build_DecSetoid
         tt
         eq_unit
         eq_unit_refl
         eq_unit_sym
         eq_unit_trans.
         
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma unitDsIso_isIso : forall {A : DecSetoid} (sg : IsSingleton A), 
                              IsDsIso A unitDecSetoid (fun x : A => tt) (fun x : unit => projT1 sg).
   Proof. intros A [a sg]; simpl; split.
      intros; auto.
      intros; auto.
      intros []; auto.
      intros x; rewrite (sg x); auto.
   Qed.

   Definition unitDsIso {A} (sg : IsSingleton A) : DsIso A unitDecSetoid := Build_DsIso (unitDsIso_isIso sg).
   
   Lemma isSingleton : IsSingleton unitDecSetoid.
   Proof. exists tt; intros []; auto. Defined.
   
   Lemma twoElements_comp : TwoElements_comp unitDecSetoid.
   Proof. intros [] []; exists tt; compute; auto. Defined.
   
   Lemma finite : Finite unitDecSetoid.
   Proof. exists (tt :: nil); intros []; trivial. Defined.

End Unit.
