Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section SimpleSeq.
   Set Implicit Arguments.

   Variable A : DecSetoid.

   Fixpoint simple (x : list A) : bool :=
      match x with
      | nil => true
      | a :: x' => if (mem a x') then false else simple x'
      end.

   Definition sseq_eq (x y : list A) : bool :=
      (negb (simple x) && negb (simple y)) || (simple x && simple y && seq_eq A x y).
      
   Lemma sseq_eq_refl : Reflexive sseq_eq.
   Proof. intros x; unfold sseq_eq; simpl; destruct (simple x); simpl; auto.
      apply seq_eq_refl.
   Qed.
   
   Lemma sseq_eq_sym : Symmetric sseq_eq.
   Proof. intros x y; unfold sseq_eq; simpl.
      destruct (simple x); destruct (simple y); simpl; auto.
      apply seq_eq_sym; auto.
   Qed.
   
   Lemma sseq_eq_trans : Transitive sseq_eq.
   Proof. intros x y z; unfold sseq_eq; simpl;
      destruct (simple x); destruct (simple y); destruct (simple z); simpl; auto.
      apply seq_eq_trans. intros h; discriminate h.
   Qed.

   Lemma mem_seq_eq : forall x y : list A, seq_eq A x y -> forall a, mem a x = mem a y.
   Proof. refine (fix mem_seq_eq x y (e : seq_eq A x y) a {struct x} : mem a x = mem a y := _).
      destruct x; destruct y; simpl in *; auto; try discriminate e.
      copy_destruct (c == c0); rewrite ew in e; [simpl in e|discriminate e].
      dseq_f. rewrite ew. destruct (a == c0); simpl; auto.
   Qed.

   Lemma seq_eq_sseq_eq : forall x y : list A, seq_eq A x y -> sseq_eq x y.
   Proof. refine (fix seq_eq_sseq_eq x y (e : seq_eq A x y) {struct x} : sseq_eq x y := _).
      destruct x; destruct y; simpl in *; trivial; try discriminate.
      unfold sseq_eq. simpl.
      copy_destruct (c == c0); rewrite ew in e; [simpl in e | discriminate e].
      dseq_f; rewrite (mem_pres_eq _ ew), (mem_seq_eq _ _ e).
      destruct (mem c0 y); auto.
      rewrite ew; simpl.
      apply seq_eq_sseq_eq.
      trivial.
   Qed.

(*
   Lemma nil_is_simple : is_simple nil.
   Proof. auto. Qed.
   
   Lemma singleton_is_simple : forall a : A, is_simple (a :: nil).
   Proof. intros a; simpl. auto. Qed.
   
   Definition simple_nil : simple_lists.
   Proof. apply inr; exists nil; apply nil_is_simple. Defined.

   Definition simple_singleton (a : A) : simple_lists.
   Proof. intros a; apply inr; exists (a :: nil); apply singleton_is_simple. Defined.
   
   Definition simple_err : simple_lists := inl _ tt.
*)
   
   Definition simpleSeqDecSetoid : DecSetoid :=
      Build_DecSetoid
         nil
         sseq_eq
         sseq_eq_refl
         sseq_eq_sym
         sseq_eq_trans.
   
   Definition err : list A :=
      let a := choose A in
      a :: a :: nil.
   
   Lemma simple_err : simple err = false.
   Proof. simpl. rewrite refl; auto. Qed.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isSingleton_comp : IsSingleton_comp simpleSeqDecSetoid.
   Proof. intros x. copy_destruct (simple x). 
      exists err; auto. simpl. unfold sseq_eq. rewrite simple_err, ew; auto.
      exists nil; auto. simpl. unfold sseq_eq. rewrite ew; auto.
   Defined.
   
   Lemma twoElements_comp : TwoElements_comp simpleSeqDecSetoid.
   Proof. intros x y; set (c := choose A).
      copy_destruct (simple x); copy_destruct (simple y).
      exists err. simpl; unfold sseq_eq. rewrite simple_err, ew, ew0; auto.
      destruct x as [|a x].
      exists (c :: nil); simpl; unfold sseq_eq. rewrite ew0. simpl. auto.
      exists nil; simpl; unfold sseq_eq; rewrite ew, ew0; simpl; auto.
      destruct y as [|a y].
      exists (c :: nil); simpl; unfold sseq_eq. rewrite ew. simpl. auto.
      exists nil; simpl; unfold sseq_eq; rewrite ew, ew0; simpl; auto.
      exists nil; simpl; unfold sseq_eq; rewrite ew, ew0; simpl; auto.
   Defined.
   
(*
   Lemma finite_comp : Finite_comp simpleSeqDecSetoid.
   Proof. intros l.
      set (l' := (map (fun x => match x with inl _ => nil | inr x' => x' end) l)).
      assert (p := Seq.finite_comp l').
      destruct p as [x px].
      exists (inr _ x).
      unfold bool_to_Prop in *; rewrite forallb_forall in *.
      intros [[]|a] q. auto.
      assert (In a l') as q'.
         unfold l'.
         rewrite in_map_iff.
         exists (inr _ a). auto.
      assert (p := px _ q').
      dseq_f; toProp. simpl. auto.
   Defined.
*)

End SimpleSeq.