Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

(*Open Scope DecSetoid_scope.*)

(*********************************************************************)
(* product of decidable setoids *)

Section Seq.
   Set Implicit Arguments.

   Variable A : DecSetoid.

   Fixpoint seq_eq (x y : list A) : bool :=
      match x, y with
         | a :: x', b :: y' => if a != b then false else seq_eq x' y'
         | nil, nil => true
         | _, _ => false
      end.

   Lemma seq_eq_refl : Reflexive seq_eq.
   Proof. intros x; induction x; auto. simpl. rewrite refl; auto. Qed.
   
   Lemma seq_eq_sym : Symmetric seq_eq.
   Proof. intros x; induction x.
      intros [|y ys]; auto.
      intros [|y ys]; auto.
      simpl. rewrite (equal_sym_b y a); destruct ((a == y)%bool); simpl; auto.
   Defined.
   
   Lemma seq_eq_trans : Transitive seq_eq.
   Proof. red.
      refine ( fix f (x y z : list A) {struct x} : 
         seq_eq x y -> seq_eq y z -> seq_eq x z := _
      ).
      destruct x as [|x xs]; destruct y as [|y ys]; destruct z as [|z zs]; 
      simpl; auto. intros h; discriminate.
      copy_destruct (x != y) as h; rewrite h.
      intros p; discriminate p.
      copy_destruct (y != z) as h1; rewrite h1.
      intros _ p; discriminate p.
      assert ((x == z)%bool) as h2.
         rewrite <- negb_pres_eq in h, h1. simpl in *.
         negb_p; dseq_f. rewrite h; auto.
      rewrite h2; simpl. apply f.
   Qed.
      
   Definition seqDecSetoid : DecSetoid :=
      Build_DecSetoid
         nil
         seq_eq
         seq_eq_refl
         seq_eq_sym
         seq_eq_trans.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma length_pres_eq : forall x y : seqDecSetoid, x == y -> length x = length y.
   Proof. refine (fix lpe (x y : seqDecSetoid) : x == y -> length x = length y := _).
      intros p; destruct x; destruct y; dseq_u.
         trivial.
         discriminate p.
         discriminate p.
         simpl; rewrite (lpe x y); auto. simpl in p. 
         destruct ((c == c0)%bool); simpl in p; auto.
         discriminate p.
   Qed.

   Fixpoint copy_seq (x : A) (n : nat) : seqDecSetoid :=
      match n with
         | S n' => x :: (copy_seq x n')
         | 0 => nil
      end.

   (* If A is singleton the (seq) is the same as (nat) *)
   Lemma seqnatDsIso_isIso : forall sg : IsSingleton A, IsDsIso seqDecSetoid natDecSetoid
                                (@length A)
                                (copy_seq (projT1 sg)).
   Proof. intros [a sg]; simpl; split.

      induction x.
      intros [|y ys] p; auto; discriminate p.
      intros [|y ys] p. discriminate p. dseq_u; simpl in *.
      destruct (a0 != y). discriminate p. auto.
      
      induction x.
      intros [|y] p; auto; discriminate p.
      intros [|y] p. dseq_u; simpl in p; discriminate p.
      dseq_u; simpl in *. rewrite refl; simpl. auto.
      
      induction x; auto.
      
      induction x; auto.
      unfold dseq; unfold dseq in IHx; simpl in *; auto.
      assert ((a == a0)%bool) as q1.
         dseq_f. rewrite (sg a0); auto.
      rewrite q1; auto.
   Qed.

   Definition seqnatDsIso (sg : IsSingleton A) : DsIso seqDecSetoid natDecSetoid := 
      Build_DsIso (seqnatDsIso_isIso sg).

   Lemma isSingleton_comp : IsSingleton_comp seqDecSetoid.
   Proof. intros [|x xs].
      exists (choose A :: nil); auto.
      exists nil; auto.
   Defined.
   
   Lemma twoElements_comp : TwoElements_comp seqDecSetoid.
   Proof. intros [|x [|x1 xs]] [|y [|y1 ys]].
      exists nil; auto.
      exists (y :: y :: nil); simpl; rewrite refl; auto.
      exists (y :: nil); simpl; rewrite refl; auto.
      exists (x :: x :: nil); simpl; rewrite refl; auto.
      exists nil; auto.
      exists nil; auto.
      exists (x :: nil); simpl; rewrite refl; auto.
      exists nil; auto.
      exists nil; auto.
   Defined.
   
   (* skip: Finite *)
   
   Lemma finite_comp : Finite_comp seqDecSetoid.
   Proof. intros l.
      assert (Exists x : seqDecSetoid, forall y, In y l -> length x > length y) as h1.
         induction l; [ exists nil; intros p q; elim (in_nil q) |].
         destruct IHl as [x px].
         destruct (le_gt_dec (length x) (length a)).
            exists ((choose A) :: a); simpl.
            intros y [p | p]. rewrite p. apply gt_Sn_n.
            assert (h := px _ p).
            assert (h1 := lt_le_trans _ _ _ h l0).
            apply (lt_le_trans _ (length a)); auto.
            
            exists x; simpl.
            intros y [p | p]. rewrite <- p; auto.
            auto.
      destruct h1 as [x px]; exists x.
      unfold bool_to_Prop; rewrite forallb_forall.
      intros a p.
      assert (h := px _ p).
      dseq_f. toProp; intros w; assert (q := length_pres_eq w).
      rewrite q in h.
      elim (gt_irrefl _ h).
   Defined.
   
End Seq.
