Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Coq.Arith.Max.
Require Import Coq.Lists.List.

(*********************************************************************)
(* Decidable setoid of natural numbers *)

Require Export Arith.
Require Export Coq.Arith.EqNat.

Lemma beq_nat_refl : Reflexive beq_nat.
Proof. intros x; rewrite <- beq_nat_refl; trivial. Defined.

Lemma beq_nat_sym : Symmetric beq_nat.
Proof. intros x y h; rewrite (beq_nat_eq x y); [ apply beq_nat_refl | rewrite h; trivial ]. Defined.

Lemma beq_nat_trans : Transitive beq_nat.
Proof. intros x y z p q. rewrite (beq_nat_eq x y), (beq_nat_eq y z);
   [ apply beq_nat_refl | rewrite q; trivial | rewrite p; trivial ].
Defined.

Definition natDecSetoid : DecSetoid :=
   Build_DecSetoid 
     0 (* carrier *)
     beq_nat (* eq *)
     beq_nat_refl (* refl *)
     beq_nat_sym (* sym *)
     beq_nat_trans (* trans *).

Lemma nat_eq : forall x y, @dseq natDecSetoid x y <-> x = y.
Proof. intros x y; split; intros h. apply beq_nat_eq. apply sym_equal. apply h.
   rewrite h; trivial.
Defined.

Lemma beq_nat_eq : forall x y, beq_nat x y <-> x = y.
Proof. intros x y; rewrite <- nat_eq; split; auto. Defined.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

Lemma isSingleton_comp : IsSingleton_comp natDecSetoid.
Proof. intros [|x]; [exists 1 | exists 0]; compute; auto. Defined.

Lemma twoElements_comp : TwoElements_comp natDecSetoid.
Proof. intros [|[|x]] [|[|y]];
   [ exists 1 (* 1 *)
   | exists 2 (* 2 *)
   | exists 1 (* 3 *)
   | exists 2 (* 4 *)
   | exists 0 (* 5 *)
   | exists 0 (* 6 *)
   | exists 1 (* 7 *)
   | exists 0 (* 8 *)
   | exists 0 (* 9 *)
   ]; apply or_intror; compute; split; trivial.
Defined.

Lemma finite_comp : Finite_comp natDecSetoid.
Proof. 
   intros l.
   assert (Exists x, forallb (fun y => leb y x) l = true).
      induction l.
         exists 0; trivial.
         destruct IHl. exists (x + a).
         simpl. andb_split. apply leb_correct. apply le_plus_r.
         induction l. trivial.
         simpl in e. andb_destruct.
         simpl. andb_split. apply leb_correct.
         dseq_f; toProp. destruct e.
         apply (le_trans _ _ _ (leb_complete _ _ H)).
         apply le_plus_l.
         dseq_f; toProp. destruct e; auto.
      destruct H.
      exists (S x).
      induction l. trivial.
      simpl in e. dseq_f; andb_destruct.
      assert (negb (@equal natDecSetoid (S x) a)) as h.
         toProp. dseq_f; rewrite nat_eq.
         assert (p := leb_complete _ _ H).
         intros q; rewrite <- q in p.
         eapply le_Sn_n; eauto.
      simpl; andb_split; [apply h | apply IHl; auto ].
Defined.
